<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Spatie\Permission\Models\Role;

class SuperAdminDashboardTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        $this->artisan('db:seed', ['--class' => 'RolePermissionSeeder']);
    }

    public function test_super_admin_can_access_dashboard()
    {
        $superAdmin = User::where('email', 'admin@fooddelivery.com')->first();
        
        $response = $this->actingAs($superAdmin, 'sanctum')
            ->getJson('/api/admin/dashboard');

        $response->assertStatus(200)
            ->assertJsonStructure([
                'success',
                'data' => [
                    'stats',
                    'charts',
                    'recent_activities',
                    'top_performers'
                ]
            ]);
    }

    public function test_regular_user_cannot_access_dashboard()
    {
        $user = User::factory()->create();
        $user->assignRole('customer');

        $response = $this->actingAs($user, 'sanctum')
            ->getJson('/api/admin/dashboard');

        $response->assertStatus(403);
    }

    public function test_dashboard_returns_correct_stats_structure()
    {
        $superAdmin = User::where('email', 'admin@fooddelivery.com')->first();
        
        $response = $this->actingAs($superAdmin, 'sanctum')
            ->getJson('/api/admin/dashboard');

        $response->assertJsonStructure([
            'data' => [
                'stats' => [
                    'total_revenue',
                    'total_orders',
                    'total_restaurants',
                    'total_users',
                    'delivery_boys',
                    'live_stats'
                ]
            ]
        ]);
    }

    public function test_dashboard_accepts_period_parameter()
    {
        $superAdmin = User::where('email', 'admin@fooddelivery.com')->first();
        
        $response = $this->actingAs($superAdmin, 'sanctum')
            ->getJson('/api/admin/dashboard?period=7');

        $response->assertStatus(200);
    }
}
