<?php

use Illuminate\Support\Facades\Route;

Route::get('/orders/dashboard', function() {
    $totalOrders = App\Models\Order::count();
    $todayOrders = App\Models\Order::whereDate('created_at', today())->count();
    $totalRevenue = App\Models\Order::where('payment_status', 'paid')->sum('total');
    $recentOrders = App\Models\Order::with(['user', 'restaurant'])->latest()->limit(10)->get();
    
    return response()->json([
        'success' => true,
        'data' => [
            'stats' => [
                'total_orders' => $totalOrders,
                'today_orders' => $todayOrders,
                'orders_trend' => 0,
                'total_revenue' => $totalRevenue,
                'today_revenue' => $totalRevenue,
                'revenue_trend' => 0,
                'pending_orders' => App\Models\Order::where('status', 'pending')->count(),
                'active_orders' => App\Models\Order::whereIn('status', ['accepted', 'preparing', 'ready', 'picked_up'])->count(),
            ],
            'recent_orders' => $recentOrders
        ]
    ]);
});