import './bootstrap';
import { createApp } from 'vue';
import { createPinia } from 'pinia';
import router from './router';
import App from './App.vue';
import EnhancedAdminDashboard from './components/Admin/EnhancedAdminDashboard.vue';
import ModernOrderDashboard from './components/SuperAdmin/ModernOrderDashboard.vue';
import SuperAdminLayout from './components/SuperAdmin/Layout.vue';
import '../css/app.css';
import '../css/transitions.css';

const app = createApp(App);
const pinia = createPinia();

// Register global components
app.component('enhanced-admin-dashboard', EnhancedAdminDashboard);
app.component('modern-order-dashboard', ModernOrderDashboard);
app.component('super-admin-layout', SuperAdminLayout);

app.use(pinia);
app.use(router);
app.mount('#app');
