<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\{User, Restaurant, Product, Order, Category, DeliveryBoy, OrderItem};
use Carbon\Carbon;

class TestDataSeeder extends Seeder
{
    public function run(): void
    {
        // Create more restaurants for testing
        $manager = User::where('email', 'manager@fooddelivery.com')->first();
        if (!$manager) $manager = User::first();

        $restaurants = [
            [
                'user_id' => $manager->id,
                'name' => 'KFC Colombo',

                'description' => 'Finger lickin good chicken',
                'email' => 'kfc@example.com',
                'phone' => '0771234570',
                'address' => '100 Galle Road, Colombo 03',
                'latitude' => 6.9271,
                'longitude' => 79.8612,

                'status' => 'approved',
                'operational_status' => 'open',
                'rating' => 4.3,

            ],
            [
                'user_id' => $manager->id,
                'name' => 'Subway Nugegoda',

                'description' => 'Fresh submarine sandwiches',
                'email' => 'subway@example.com',
                'phone' => '0771234571',
                'address' => '200 High Level Road, Nugegoda',
                'latitude' => 6.8649,
                'longitude' => 79.8997,

                'status' => 'approved',
                'operational_status' => 'open',
                'rating' => 4.1,

            ],
            [
                'user_id' => $manager->id,
                'name' => 'Chinese Dragon',

                'description' => 'Authentic Chinese cuisine',
                'email' => 'dragon@example.com',
                'phone' => '0771234572',
                'address' => '50 Duplication Road, Colombo 04',
                'latitude' => 6.8905,
                'longitude' => 79.8570,

                'status' => 'approved',
                'operational_status' => 'open',
                'rating' => 4.6,

            ],
        ];

        foreach ($restaurants as $rest) {
            Restaurant::firstOrCreate(['name' => $rest['name']], $rest);
        }

        // Add more products
        $kfc = Restaurant::where('name', 'KFC Colombo')->first();
        $subway = Restaurant::where('name', 'Subway Nugegoda')->first();
        $chinese = Restaurant::where('name', 'Chinese Dragon')->first();

        $products = [
            // KFC Products
            [
                'restaurant_id' => $kfc->id,
                'category_id' => 2,
                'name' => 'Zinger Burger',
                'slug' => 'zinger-burger',
                'description' => 'Spicy chicken burger with lettuce and mayo',
                'price' => 650.00,
                'image' => 'kfc-zinger.jpg',
                'is_available' => true,
                'is_active' => true,
                'is_approved' => true,
                'stock_quantity' => 80,
                'rating' => 4.4,
                'total_reviews' => 45,
                'total_orders' => 300,
            ],
            [
                'restaurant_id' => $kfc->id,
                'category_id' => 2,
                'name' => 'Hot & Crispy Chicken',
                'slug' => 'hot-crispy-chicken',
                'description' => '2 pieces of crispy fried chicken',
                'price' => 890.00,
                'image' => 'kfc-chicken.jpg',
                'is_available' => true,
                'is_active' => true,
                'is_approved' => true,
                'stock_quantity' => 60,
                'rating' => 4.5,
                'total_reviews' => 60,
                'total_orders' => 250,
            ],
            // Subway Products
            [
                'restaurant_id' => $subway->id,
                'category_id' => 2,
                'name' => 'Italian BMT',
                'slug' => 'italian-bmt',
                'description' => '6 inch sub with pepperoni, salami and ham',
                'price' => 750.00,
                'image' => 'subway-bmt.jpg',
                'is_available' => true,
                'is_active' => true,
                'is_approved' => true,
                'stock_quantity' => 40,
                'rating' => 4.2,
                'total_reviews' => 30,
                'total_orders' => 180,
            ],
            [
                'restaurant_id' => $subway->id,
                'category_id' => 2,
                'name' => 'Chicken Teriyaki',
                'slug' => 'chicken-teriyaki',
                'description' => '6 inch sub with grilled chicken and teriyaki sauce',
                'price' => 680.00,
                'image' => 'subway-teriyaki.jpg',
                'is_available' => true,
                'is_active' => true,
                'is_approved' => true,
                'stock_quantity' => 35,
                'rating' => 4.3,
                'total_reviews' => 25,
                'total_orders' => 160,
            ],
            // Chinese Products
            [
                'restaurant_id' => $chinese->id,
                'category_id' => 4,
                'name' => 'Sweet & Sour Pork',
                'slug' => 'sweet-sour-pork',
                'description' => 'Crispy pork with sweet and sour sauce',
                'price' => 1200.00,
                'image' => 'chinese-pork.jpg',
                'is_available' => true,
                'is_active' => true,
                'is_approved' => true,
                'stock_quantity' => 25,
                'rating' => 4.7,
                'total_reviews' => 40,
                'total_orders' => 120,
            ],
            [
                'restaurant_id' => $chinese->id,
                'category_id' => 4,
                'name' => 'Chicken Fried Rice',
                'slug' => 'chicken-fried-rice',
                'description' => 'Wok-fried rice with chicken and vegetables',
                'price' => 950.00,
                'image' => 'chinese-rice.jpg',
                'is_available' => true,
                'is_active' => true,
                'is_approved' => true,
                'stock_quantity' => 30,
                'rating' => 4.4,
                'total_reviews' => 35,
                'total_orders' => 200,
            ],
        ];

        foreach ($products as $prod) {
            Product::firstOrCreate(['slug' => $prod['slug']], $prod);
        }

        // Create more test orders with different statuses
        $customer = User::where('email', 'customer@fooddelivery.com')->first();
        if (!$customer) $customer = User::skip(1)->first();

        $allRestaurants = Restaurant::all();
        $statuses = ['pending', 'accepted', 'preparing', 'ready', 'picked_up', 'delivered'];

        for ($i = 21; $i <= 50; $i++) {
            $restaurant = $allRestaurants->random();
            $status = $statuses[array_rand($statuses)];
            $orderDate = Carbon::now()->subDays(rand(0, 7));
            
            $subtotal = rand(600, 2500);
            $deliveryFee = 150;
            $serviceCharge = round($subtotal * 0.1);
            $tax = round($subtotal * 0.08);
            $total = $subtotal + $deliveryFee + $serviceCharge + $tax;
            
            $order = Order::create([
                'order_number' => 'FD' . str_pad($i, 6, '0', STR_PAD_LEFT),
                'user_id' => $customer->id,
                'restaurant_id' => $restaurant->id,
                'status' => $status,
                'delivery_address' => '456 Test Street, Colombo 05',
                'delivery_latitude' => 6.9271,
                'delivery_longitude' => 79.8612,
                'delivery_phone' => '0771234999',
                'subtotal' => $subtotal,
                'delivery_fee' => $deliveryFee,
                'service_charge' => $serviceCharge,
                'tax' => $tax,
                'total' => $total,
                'distance_km' => rand(3, 12),
                'estimated_delivery_time' => rand(25, 45),
                'payment_method' => ['cash', 'card', 'wallet'][rand(0, 2)],
                'payment_status' => $status === 'delivered' ? 'paid' : 'pending',
                'customer_notes' => 'Test order - ' . $status,
                'created_at' => $orderDate,
                'updated_at' => $orderDate,
            ]);

            // Add order items
            $restaurantProducts = Product::where('restaurant_id', $restaurant->id)->take(rand(1, 3))->get();
            foreach ($restaurantProducts as $product) {
                $quantity = rand(1, 2);
                OrderItem::create([
                    'order_id' => $order->id,
                    'product_id' => $product->id,
                    'product_name' => $product->name,
                    'quantity' => $quantity,
                    'unit_price' => $product->price,
                    'total_price' => $product->price * $quantity,
                    'special_notes' => 'Test item',
                ]);
            }
        }

        echo "✅ Test data created successfully!\n";
        echo "📊 Added:\n";
        echo "   - 3 new restaurants (KFC, Subway, Chinese Dragon)\n";
        echo "   - 6 new products\n";
        echo "   - 30 new test orders with various statuses\n";
        echo "   - Order items for each order\n";
    }
}