<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    public function run()
    {
        $settings = [
            // General
            ['key' => 'app_name', 'value' => 'Food Delivery System', 'type' => 'text', 'group' => 'general'],
            ['key' => 'app_email', 'value' => 'admin@fooddelivery.com', 'type' => 'email', 'group' => 'general'],
            ['key' => 'app_phone', 'value' => '+94 11 234 5678', 'type' => 'text', 'group' => 'general'],
            ['key' => 'currency', 'value' => 'LKR', 'type' => 'text', 'group' => 'general'],
            ['key' => 'timezone', 'value' => 'Asia/Colombo', 'type' => 'text', 'group' => 'general'],
            
            // Commission
            ['key' => 'restaurant_commission', 'value' => '10', 'type' => 'number', 'group' => 'commission'],
            ['key' => 'delivery_commission', 'value' => '5', 'type' => 'number', 'group' => 'commission'],
            ['key' => 'tax_rate', 'value' => '8', 'type' => 'number', 'group' => 'commission'],
            ['key' => 'service_charge', 'value' => '2', 'type' => 'number', 'group' => 'commission'],
            
            // Delivery
            ['key' => 'base_delivery_fee', 'value' => '100', 'type' => 'number', 'group' => 'delivery'],
            ['key' => 'per_km_charge', 'value' => '50', 'type' => 'number', 'group' => 'delivery'],
            ['key' => 'max_delivery_distance', 'value' => '20', 'type' => 'number', 'group' => 'delivery'],
            ['key' => 'min_order_amount', 'value' => '500', 'type' => 'number', 'group' => 'delivery'],
            
            // Order
            ['key' => 'order_auto_cancel_time', 'value' => '30', 'type' => 'number', 'group' => 'order'],
            ['key' => 'order_preparation_time', 'value' => '20', 'type' => 'number', 'group' => 'order'],
            ['key' => 'allow_cash_on_delivery', 'value' => '1', 'type' => 'boolean', 'group' => 'order'],
            ['key' => 'allow_online_payment', 'value' => '1', 'type' => 'boolean', 'group' => 'order'],
            
            // Notification
            ['key' => 'email_notifications', 'value' => '1', 'type' => 'boolean', 'group' => 'notification'],
            ['key' => 'sms_notifications', 'value' => '1', 'type' => 'boolean', 'group' => 'notification'],
            ['key' => 'push_notifications', 'value' => '1', 'type' => 'boolean', 'group' => 'notification'],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(['key' => $setting['key']], $setting);
        }
    }
}
