<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Order;
use App\Models\OrderFlag;

class OrderFlagSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Creating order flags...');
        
        $orders = Order::limit(30)->get();
        $flagTypes = ['late_delivery', 'multiple_rejects', 'payment_issue', 'customer_complaint', 'quality_issue'];
        $severities = ['low', 'medium', 'high', 'critical'];
        
        foreach ($orders as $order) {
            // 25% chance of having a flag
            if (rand(1, 100) <= 25) {
                $type = $flagTypes[array_rand($flagTypes)];
                $severity = $severities[array_rand($severities)];
                
                $description = match($type) {
                    'late_delivery' => 'Order delivered 45 minutes late',
                    'multiple_rejects' => 'Order rejected by 3 delivery boys',
                    'payment_issue' => 'Payment gateway timeout issue',
                    'customer_complaint' => 'Customer complained about food quality',
                    'quality_issue' => 'Restaurant reported missing items',
                };
                
                OrderFlag::create([
                    'order_id' => $order->id,
                    'type' => $type,
                    'severity' => $severity,
                    'resolved' => rand(0, 1),
                    'description' => $description,
                    'created_at' => $order->created_at->addMinutes(rand(30, 120)),
                    'updated_at' => $order->created_at->addMinutes(rand(30, 120))
                ]);
            }
        }
        
        $this->command->info('Order flags created successfully!');
    }
}