<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Restaurant;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class MassRestaurantSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Creating 20,000 restaurants...');
        
        $restaurantTypes = ['Pizza', 'Burger', 'Chinese', 'Indian', 'Thai', 'Italian', 'Mexican', 'Japanese', 'Korean', 'Sri Lankan'];
        $areas = ['Colombo', 'Kandy', 'Galle', 'Negombo', 'Jaffna', 'Kurunegala', 'Anuradhapura', 'Ratnapura', 'Batticaloa', 'Trincomalee'];
        
        $startId = User::max('id') + 1;
        
        for ($i = 0; $i < 2000; $i++) {
            $userId = $startId + $i;
            
            // Create restaurant owner
            $owner = User::create([
                'name' => "Restaurant Owner {$userId}",
                'email' => "restaurant{$userId}@example.com",
                'phone' => '077' . str_pad($userId, 7, '0', STR_PAD_LEFT),
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
            ]);
            $owner->assignRole('manager');
            
            // Create restaurant
            $type = $restaurantTypes[array_rand($restaurantTypes)];
            $area = $areas[array_rand($areas)];
            
            Restaurant::create([
                'user_id' => $owner->id,
                'name' => "{$type} House {$userId}",
                'description' => "Best {$type} restaurant in {$area}",
                'address' => "No. {$userId}, Main Street, {$area}",
                'phone' => '011' . str_pad($userId, 7, '0', STR_PAD_LEFT),
                'email' => "restaurant{$userId}@example.com",
                'latitude' => 6.9271 + (rand(-100, 100) / 1000),
                'longitude' => 79.8612 + (rand(-100, 100) / 1000),
                'status' => 'approved',
                'operational_status' => rand(0, 1) ? 'open' : 'closed',
                'rating' => rand(30, 50) / 10,
            ]);
            
            if (($i + 1) % 1000 == 0) {
                $this->command->info("Created " . ($i + 1) . " restaurants...");
            }
        }
        
        $this->command->info('20,000 restaurants created successfully!');
    }
}