<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class DeliveryBoyPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // Create permissions
        $permissions = [
            'view-delivery-boys',
            'create-delivery-boys',
            'update-delivery-boys',
            'delete-delivery-boys',
            'block-delivery-boys',
            'verify-delivery-boys',
            'manage-delivery-earnings',
            'manage-delivery-payouts',
            'view-delivery-documents',
            'approve-delivery-documents',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
        }

        // Assign permissions to super-admin
        $superAdmin = Role::firstOrCreate(['name' => 'super-admin', 'guard_name' => 'web']);
        $superAdmin->givePermissionTo($permissions);

        // Assign permissions to admin
        $admin = Role::firstOrCreate(['name' => 'admin', 'guard_name' => 'web']);
        $admin->givePermissionTo([
            'view-delivery-boys',
            'update-delivery-boys',
            'block-delivery-boys',
            'manage-delivery-earnings',
            'view-delivery-documents',
        ]);

        // Create delivery-boy role (limited permissions)
        $deliveryBoy = Role::firstOrCreate(['name' => 'delivery-boy', 'guard_name' => 'web']);
        // Delivery boys don't need these admin permissions
    }
}
