<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DeliveryBoyAreasSeeder extends Seeder
{
    public function run(): void
    {
        $areas = [
            // Colombo areas
            ['delivery_boy_id' => 1, 'area_name' => 'Colombo 03', 'city' => 'Colombo', 'latitude' => 6.9271, 'longitude' => 79.8612, 'radius_km' => 5],
            ['delivery_boy_id' => 2, 'area_name' => 'Colombo 07', 'city' => 'Colombo', 'latitude' => 6.9147, 'longitude' => 79.8736, 'radius_km' => 5],
            ['delivery_boy_id' => 5, 'area_name' => 'Colombo 05', 'city' => 'Colombo', 'latitude' => 6.8905, 'longitude' => 79.8574, 'radius_km' => 5],
            ['delivery_boy_id' => 8, 'area_name' => 'Colombo 04', 'city' => 'Colombo', 'latitude' => 6.8935, 'longitude' => 79.8597, 'radius_km' => 5],
            ['delivery_boy_id' => 10, 'area_name' => 'Colombo 06', 'city' => 'Colombo', 'latitude' => 6.8887, 'longitude' => 79.8607, 'radius_km' => 5],
            
            // Kandy areas
            ['delivery_boy_id' => 3, 'area_name' => 'Kandy City', 'city' => 'Kandy', 'latitude' => 7.2906, 'longitude' => 80.6337, 'radius_km' => 5],
            ['delivery_boy_id' => 7, 'area_name' => 'Peradeniya', 'city' => 'Kandy', 'latitude' => 7.2571, 'longitude' => 80.5967, 'radius_km' => 5],
            
            // Galle area
            ['delivery_boy_id' => 4, 'area_name' => 'Galle Fort', 'city' => 'Galle', 'latitude' => 6.0329, 'longitude' => 80.2168, 'radius_km' => 5],
            
            // Negombo area
            ['delivery_boy_id' => 6, 'area_name' => 'Negombo City', 'city' => 'Negombo', 'latitude' => 7.2083, 'longitude' => 79.8358, 'radius_km' => 5],
            
            // Gampaha area
            ['delivery_boy_id' => 9, 'area_name' => 'Gampaha Town', 'city' => 'Gampaha', 'latitude' => 7.0873, 'longitude' => 80.0142, 'radius_km' => 5],
        ];

        foreach ($areas as $area) {
            DB::table('delivery_boy_areas')->insert([
                'delivery_boy_id' => $area['delivery_boy_id'],
                'area_name' => $area['area_name'],
                'city' => $area['city'],
                'latitude' => $area['latitude'],
                'longitude' => $area['longitude'],
                'radius_km' => $area['radius_km'],
                'is_primary' => true,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
