<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            ['name' => 'Breakfast', 'sort_order' => 1],
            ['name' => 'Lunch', 'sort_order' => 2],
            ['name' => 'Dinner', 'sort_order' => 3],
            ['name' => 'Short Eats', 'sort_order' => 4],
            ['name' => 'Buns', 'sort_order' => 5],
            ['name' => 'Tea', 'sort_order' => 6],
            ['name' => 'Coffee', 'sort_order' => 7],
            ['name' => 'Soft Drinks', 'sort_order' => 8],
            ['name' => 'Chinese', 'sort_order' => 9],
            ['name' => 'Kottu', 'sort_order' => 10],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }
    }
}
