<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

return new class extends Migration
{
    public function up(): void
    {
        $products = DB::table('products')->whereNotNull('image')->get();
        
        foreach ($products as $product) {
            $oldPath = $product->image;
            
            // Skip if already in correct format
            if (str_starts_with($oldPath, '/images/products/')) {
                continue;
            }
            
            // Get filename from old path (e.g., "products/abc.jpg" -> "abc.jpg")
            $filename = basename($oldPath);
            $newPath = '/images/products/' . $filename;
            
            // Copy file from storage to public
            $storagePath = storage_path('app/public/' . $oldPath);
            $publicPath = public_path('images/products/' . $filename);
            
            if (file_exists($storagePath)) {
                // Ensure directory exists
                if (!file_exists(dirname($publicPath))) {
                    mkdir(dirname($publicPath), 0755, true);
                }
                
                // Copy file
                copy($storagePath, $publicPath);
                
                // Update database
                DB::table('products')
                    ->where('id', $product->id)
                    ->update(['image' => $newPath]);
                    
                echo "Migrated: {$oldPath} -> {$newPath}\n";
            }
        }
    }

    public function down(): void
    {
        // Revert paths back to storage format
        $products = DB::table('products')
            ->where('image', 'like', '/images/products/%')
            ->get();
        
        foreach ($products as $product) {
            $filename = basename($product->image);
            $oldPath = 'products/' . $filename;
            
            DB::table('products')
                ->where('id', $product->id)
                ->update(['image' => $oldPath]);
        }
    }
};
