<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->unsignedBigInteger('assigned_delivery_boy_id')->nullable()->after('status');
            $table->timestamp('assignment_attempted_at')->nullable();
            $table->integer('assignment_attempts')->default(0);
            
            $table->index('assigned_delivery_boy_id');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn(['assigned_delivery_boy_id', 'assignment_attempted_at', 'assignment_attempts']);
        });
    }
};
