<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('product_addons', function (Blueprint $table) {
            $table->foreignId('category_addon_id')->nullable()->after('product_id')->constrained('category_addons')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('product_addons', function (Blueprint $table) {
            $table->dropForeign(['category_addon_id']);
            $table->dropColumn('category_addon_id');
        });
    }
};
