<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('restaurant_products', function (Blueprint $table) {
            if (!Schema::hasColumn('restaurant_products', 'discount_percentage')) {
                $table->decimal('discount_percentage', 5, 2)->default(0)->after('price');
            }
            if (!Schema::hasColumn('restaurant_products', 'special_start_date')) {
                $table->date('special_start_date')->nullable()->after('discount_percentage');
            }
            if (!Schema::hasColumn('restaurant_products', 'special_end_date')) {
                $table->date('special_end_date')->nullable()->after('special_start_date');
            }
            if (!Schema::hasColumn('restaurant_products', 'special_notes')) {
                $table->text('special_notes')->nullable()->after('is_featured');
            }
            if (!Schema::hasColumn('restaurant_products', 'custom_image')) {
                $table->string('custom_image')->nullable()->after('special_notes');
            }
        });
    }

    public function down(): void
    {
        Schema::table('restaurant_products', function (Blueprint $table) {
            $columns = ['discount_percentage', 'special_start_date', 'special_end_date', 'special_notes', 'custom_image'];
            foreach ($columns as $column) {
                if (Schema::hasColumn('restaurant_products', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
