<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            if (!Schema::hasColumn('products', 'restaurant_id')) {
                $table->foreignId('restaurant_id')->nullable()->after('id')->constrained()->onDelete('cascade');
            }
            if (!Schema::hasColumn('products', 'price')) {
                $table->decimal('price', 10, 2)->default(0)->after('description');
            }
            if (!Schema::hasColumn('products', 'discount')) {
                $table->decimal('discount', 5, 2)->default(0)->after('price');
            }
            if (!Schema::hasColumn('products', 'preparation_time')) {
                $table->integer('preparation_time')->default(15)->after('discount');
            }
            if (!Schema::hasColumn('products', 'is_available')) {
                $table->boolean('is_available')->default(true)->after('preparation_time');
            }
        });

        if (Schema::hasColumn('product_variations', 'price_adjustment') && !Schema::hasColumn('product_variations', 'price')) {
            Schema::table('product_variations', function (Blueprint $table) {
                $table->decimal('price', 10, 2)->default(0)->after('value');
            });
            
            DB::statement('UPDATE product_variations SET price = price_adjustment');
            
            Schema::table('product_variations', function (Blueprint $table) {
                $table->dropColumn('price_adjustment');
            });
        }

        Schema::table('product_variations', function (Blueprint $table) {
            if (Schema::hasColumn('product_variations', 'is_available')) {
                $table->dropColumn('is_available');
            }
            if (Schema::hasColumn('product_variations', 'sort_order')) {
                $table->dropColumn('sort_order');
            }
        });

        Schema::table('product_addons', function (Blueprint $table) {
            if (Schema::hasColumn('product_addons', 'is_available')) {
                $table->dropColumn('is_available');
            }
            if (Schema::hasColumn('product_addons', 'sort_order')) {
                $table->dropColumn('sort_order');
            }
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['restaurant_id', 'price', 'discount', 'preparation_time', 'is_available']);
        });

        Schema::table('product_variations', function (Blueprint $table) {
            $table->renameColumn('price', 'price_adjustment');
            $table->boolean('is_available')->default(true);
            $table->integer('sort_order')->default(0);
        });

        Schema::table('product_addons', function (Blueprint $table) {
            $table->boolean('is_available')->default(true);
            $table->integer('sort_order')->default(0);
        });
    }
};
