<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Orders table indexes
        Schema::table('orders', function (Blueprint $table) {
            $table->index('status');
            $table->index('restaurant_id');
            $table->index('user_id');
            $table->index('created_at');
            $table->index(['status', 'created_at']);
            $table->index(['restaurant_id', 'status']);
        });

        // Delivery boys table indexes
        Schema::table('delivery_boys', function (Blueprint $table) {
            $table->index('status');
            $table->index('verification_status');
            $table->index(['status', 'verification_status']);
        });

        // Deliveries table indexes
        Schema::table('deliveries', function (Blueprint $table) {
            $table->index('order_id');
            $table->index('delivery_boy_id');
            $table->index('status');
        });

        // Restaurants table indexes
        Schema::table('restaurants', function (Blueprint $table) {
            $table->index('status');
            $table->index('user_id');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropIndex(['restaurant_id']);
            $table->dropIndex(['user_id']);
            $table->dropIndex(['created_at']);
            $table->dropIndex(['status', 'created_at']);
            $table->dropIndex(['restaurant_id', 'status']);
        });

        Schema::table('delivery_boys', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropIndex(['verification_status']);
            $table->dropIndex(['status', 'verification_status']);
        });

        Schema::table('deliveries', function (Blueprint $table) {
            $table->dropIndex(['order_id']);
            $table->dropIndex(['delivery_boy_id']);
            $table->dropIndex(['status']);
        });

        Schema::table('restaurants', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropIndex(['user_id']);
        });
    }
};
