<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('delivery_boy_ratings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('delivery_boy_id')->constrained()->onDelete('cascade');
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('customer_id')->constrained('users')->onDelete('cascade');
            $table->tinyInteger('rating'); // 1-5
            $table->text('review')->nullable();
            $table->tinyInteger('delivery_time_rating')->nullable(); // 1-5
            $table->tinyInteger('behavior_rating')->nullable(); // 1-5
            $table->tinyInteger('food_condition_rating')->nullable(); // 1-5
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('delivery_boy_ratings');
    }
};
