<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('delivery_boy_documents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('delivery_boy_id')->constrained()->onDelete('cascade');
            $table->enum('document_type', ['national_id', 'driving_license', 'vehicle_registration', 'insurance', 'police_report', 'other']);
            $table->string('document_number', 100)->nullable();
            $table->string('document_file');
            $table->date('issue_date')->nullable();
            $table->date('expiry_date')->nullable();
            $table->enum('verification_status', ['pending', 'verified', 'rejected'])->default('pending');
            $table->foreignId('verified_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('verified_at')->nullable();
            $table->text('rejection_reason')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('delivery_boy_documents');
    }
};
