<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('delivery_boy_vehicles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('delivery_boy_id')->constrained()->onDelete('cascade');
            $table->enum('vehicle_type', ['bike', 'scooter', 'bicycle', 'car', 'van']);
            $table->string('vehicle_make', 100)->nullable();
            $table->string('vehicle_model', 100)->nullable();
            $table->string('vehicle_number', 50);
            $table->string('vehicle_color', 50)->nullable();
            $table->year('registration_year')->nullable();
            $table->string('insurance_number', 100)->nullable();
            $table->date('insurance_expiry')->nullable();
            $table->string('vehicle_photo')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('delivery_boy_vehicles');
    }
};
