<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('restaurants', function (Blueprint $table) {
            // Remove unnecessary columns if they exist
            $columnsToRemove = [
                'slug',
                'delivery_radius',
                'minimum_order',
                'delivery_fee',
                'service_charge_percentage',
                'tax_percentage',
                'opening_time',
                'closing_time',
                'logo',
                'cover_image',
                'images',
                'total_reviews',
                'is_featured'
            ];

            foreach ($columnsToRemove as $column) {
                if (Schema::hasColumn('restaurants', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }

    public function down(): void
    {
        Schema::table('restaurants', function (Blueprint $table) {
            $table->string('slug')->nullable();
            $table->decimal('delivery_radius', 8, 2)->nullable();
            $table->decimal('minimum_order', 10, 2)->nullable();
            $table->decimal('delivery_fee', 10, 2)->nullable();
            $table->decimal('service_charge_percentage', 5, 2)->nullable();
            $table->decimal('tax_percentage', 5, 2)->nullable();
            $table->time('opening_time')->nullable();
            $table->time('closing_time')->nullable();
            $table->string('logo')->nullable();
            $table->string('cover_image')->nullable();
            $table->json('images')->nullable();
            $table->integer('total_reviews')->default(0);
            $table->boolean('is_featured')->default(false);
        });
    }
};
