<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('admin_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string'); // string, number, boolean, json
            $table->text('description')->nullable();
            $table->boolean('is_public')->default(false);
            $table->timestamps();
        });

        // Insert default settings
        $settings = [
            ['key' => 'delivery_fee_per_km', 'value' => '1.00', 'type' => 'number', 'description' => 'Delivery fee per kilometer'],
            ['key' => 'tax_percentage', 'value' => '5.00', 'type' => 'number', 'description' => 'Tax percentage'],
            ['key' => 'service_charge_percentage', 'value' => '2.50', 'type' => 'number', 'description' => 'Service charge percentage'],
            ['key' => 'minimum_order_value', 'value' => '10.00', 'type' => 'number', 'description' => 'Minimum order value'],
            ['key' => 'app_maintenance_mode', 'value' => 'false', 'type' => 'boolean', 'description' => 'App maintenance mode'],
            ['key' => 'google_maps_api_key', 'value' => '', 'type' => 'string', 'description' => 'Google Maps API Key'],
            ['key' => 'stripe_publishable_key', 'value' => '', 'type' => 'string', 'description' => 'Stripe Publishable Key'],
            ['key' => 'stripe_secret_key', 'value' => '', 'type' => 'string', 'description' => 'Stripe Secret Key'],
            ['key' => 'payhere_merchant_id', 'value' => '', 'type' => 'string', 'description' => 'PayHere Merchant ID'],
            ['key' => 'payhere_secret_key', 'value' => '', 'type' => 'string', 'description' => 'PayHere Secret Key'],
            ['key' => 'admin_commission_percentage', 'value' => '15.00', 'type' => 'number', 'description' => 'Admin commission percentage'],
            ['key' => 'delivery_boy_commission_percentage', 'value' => '10.00', 'type' => 'number', 'description' => 'Delivery boy commission percentage'],
        ];

        foreach ($settings as $setting) {
            DB::table('admin_settings')->insert($setting);
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('admin_settings');
    }
};