<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('restaurants', function (Blueprint $table) {
            $table->boolean('is_blocked')->default(false);
            $table->text('blocked_reason')->nullable();
            $table->foreignId('blocked_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('blocked_at')->nullable();
            $table->timestamp('blocked_until')->nullable();
            $table->foreignId('unblocked_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('unblocked_at')->nullable();
            $table->text('unblock_reason')->nullable();
            
            $table->index(['is_blocked', 'blocked_until']);
        });
    }

    public function down()
    {
        Schema::table('restaurants', function (Blueprint $table) {
            $table->dropColumn([
                'is_blocked', 'blocked_reason', 'blocked_by', 'blocked_at', 
                'blocked_until', 'unblocked_by', 'unblocked_at', 'unblock_reason'
            ]);
        });
    }
};