<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('order_flags', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['late_delivery', 'multiple_rejects', 'payment_issue', 'customer_complaint', 'quality_issue']);
            $table->enum('severity', ['low', 'medium', 'high', 'critical'])->default('medium');
            $table->boolean('resolved')->default(false);
            $table->text('description')->nullable();
            $table->timestamps();
            
            $table->index(['order_id', 'resolved']);
            $table->index(['type', 'severity']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('order_flags');
    }
};