<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('deliveries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('delivery_boy_id')->nullable()->constrained()->onDelete('set null');
            $table->enum('status', [
                'pending',
                'assigned',
                'accepted',
                'rejected',
                'picked_up',
                'on_the_way',
                'delivered',
                'failed'
            ])->default('pending');
            
            // Pickup Location (Restaurant)
            $table->decimal('pickup_latitude', 10, 7);
            $table->decimal('pickup_longitude', 10, 7);
            $table->text('pickup_address');
            
            // Delivery Location (Customer)
            $table->decimal('delivery_latitude', 10, 7);
            $table->decimal('delivery_longitude', 10, 7);
            $table->text('delivery_address');
            
            // Distance & Time
            $table->decimal('distance_km', 8, 2);
            $table->integer('estimated_time')->nullable(); // in minutes
            $table->integer('actual_time')->nullable(); // in minutes
            
            // Earnings
            $table->decimal('delivery_fee', 10, 2);
            $table->decimal('delivery_boy_earning', 10, 2)->nullable();
            $table->decimal('platform_commission', 10, 2)->nullable();
            
            // Tracking
            $table->json('route_coordinates')->nullable();
            $table->text('delivery_notes')->nullable();
            $table->text('rejection_reason')->nullable();
            
            // Timestamps
            $table->timestamp('assigned_at')->nullable();
            $table->timestamp('accepted_at')->nullable();
            $table->timestamp('picked_up_at')->nullable();
            $table->timestamp('delivered_at')->nullable();
            
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('deliveries');
    }
};
