<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\User;

class RestaurantFactory extends Factory
{
    public function definition()
    {
        $name = fake()->company();
        $user = User::factory()->create();
        return [
            'user_id' => $user->id,
            'name' => $name,
            'slug' => Str::slug($name) . '-' . Str::random(6),
            'description' => fake()->sentence(),
            'address' => fake()->address(),
            'phone' => fake()->phoneNumber(),
            'email' => fake()->unique()->safeEmail(),
            'latitude' => fake()->latitude(),
            'longitude' => fake()->longitude(),
            'delivery_radius' => 10,
            'minimum_order' => 0,
            'delivery_fee' => 0,
            'service_charge_percentage' => 0,
            'tax_percentage' => 0,
            'opening_time' => null,
            'closing_time' => null,
            'status' => 'approved',
            'operational_status' => 'open',
            'logo' => null,
            'cover_image' => null,
            'images' => [],
            'rating' => 0,
            'total_reviews' => 0,
            'is_featured' => false,
        ];
    }
}
