<?php

namespace App\Services;

class MapService
{
    private $apiKey = 'AIzaSyBrfy7IL9up-52b6vB0DyQdMTZYAJPDOuw';

    public function calculateDistance($lat1, $lon1, $lat2, $lon2)
    {
        $earthRadius = 6371; // km

        $dLat = deg2rad($lat2 - $lat1);
        $dLon = deg2rad($lon2 - $lon1);

        $a = sin($dLat / 2) * sin($dLat / 2) +
             cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
             sin($dLon / 2) * sin($dLon / 2);

        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

        return round($earthRadius * $c, 2);
    }

    public function getDirections($originLat, $originLng, $destLat, $destLng)
    {
        try {
            $url = "https://maps.googleapis.com/maps/api/directions/json?" . http_build_query([
                'origin' => "{$originLat},{$originLng}",
                'destination' => "{$destLat},{$destLng}",
                'mode' => 'driving',
                'key' => $this->apiKey
            ]);

            $response = file_get_contents($url);
            $data = json_decode($response, true);

            if ($data['status'] === 'OK' && isset($data['routes'][0]['legs'][0])) {
                $leg = $data['routes'][0]['legs'][0];
                return [
                    'distance_km' => round($leg['distance']['value'] / 1000, 2),
                    'distance_text' => $leg['distance']['text'],
                    'duration_minutes' => round($leg['duration']['value'] / 60),
                    'duration_text' => $leg['duration']['text'],
                    'start_address' => $leg['start_address'],
                    'end_address' => $leg['end_address'],
                ];
            }

            // Fallback to haversine calculation
            return [
                'distance_km' => $this->calculateDistance($originLat, $originLng, $destLat, $destLng),
                'distance_text' => null,
                'duration_minutes' => null,
                'duration_text' => null,
                'start_address' => null,
                'end_address' => null,
            ];
        } catch (\Exception $e) {
            \Log::error('Google Maps API error: ' . $e->getMessage());
            return [
                'distance_km' => $this->calculateDistance($originLat, $originLng, $destLat, $destLng),
                'distance_text' => null,
                'duration_minutes' => null,
                'duration_text' => null,
                'start_address' => null,
                'end_address' => null,
            ];
        }
    }

    public function calculateDeliveryFee($distance)
    {
        $baseFee = 50;
        $perKmFee = 10;
        
        return $baseFee + ($distance * $perKmFee);
    }

    public function estimateDeliveryTime($distance)
    {
        $avgSpeed = 30; // km/h
        $preparationTime = 20; // minutes
        
        $travelTime = ($distance / $avgSpeed) * 60;
        
        return round($preparationTime + $travelTime);
    }
}
