<?php

namespace App\Policies;

use App\Models\Restaurant;
use App\Models\User;

class RestaurantPolicy
{
    public function update(User $user, Restaurant $restaurant): bool
    {
        if ($user->hasRole('admin')) {
            return true;
        }
        return $user->hasRole('manager') && $restaurant->user_id === $user->id;
    }

    public function delete(User $user, Restaurant $restaurant): bool
    {
        if ($user->hasRole('admin')) {
            return true;
        }
        return $user->hasRole('manager') && $restaurant->user_id === $user->id;
    }
}
