<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DeliveryBoyDocument extends Model
{
    use HasFactory;

    const TYPE_NATIONAL_ID = 'national_id';
    const TYPE_DRIVING_LICENSE = 'driving_license';
    const TYPE_VEHICLE_REGISTRATION = 'vehicle_registration';
    const TYPE_INSURANCE = 'insurance';
    const TYPE_POLICE_REPORT = 'police_report';
    const TYPE_OTHER = 'other';

    const STATUS_PENDING = 'pending';
    const STATUS_VERIFIED = 'verified';
    const STATUS_REJECTED = 'rejected';

    protected $fillable = [
        'delivery_boy_id', 'document_type', 'document_number', 'document_file',
        'issue_date', 'expiry_date', 'verification_status', 'verified_by',
        'verified_at', 'rejection_reason'
    ];

    protected $casts = [
        'issue_date' => 'date',
        'expiry_date' => 'date',
        'verified_at' => 'datetime',
    ];

    public function deliveryBoy(): BelongsTo
    {
        return $this->belongsTo(DeliveryBoy::class);
    }

    public function verifiedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'verified_by');
    }
}
