<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DeliveryBoy extends Model
{
    use HasFactory, SoftDeletes;

    const STATUS_ONLINE = 'online';
    const STATUS_OFFLINE = 'offline';
    const STATUS_ON_DELIVERY = 'on_delivery';
    const STATUS_BLOCKED = 'blocked';

    const VERIFICATION_PENDING = 'pending';
    const VERIFICATION_VERIFIED = 'verified';
    const VERIFICATION_REJECTED = 'rejected';

    protected $fillable = [
        'user_id', 'full_name', 'phone', 'email', 'address', 'city', 'postal_code',
        'latitude', 'longitude', 'status', 'verification_status', 'profile_photo',
        'national_id', 'date_of_birth', 'emergency_contact_name', 'emergency_contact_phone',
        'rating', 'total_ratings', 'total_deliveries', 'successful_deliveries',
        'commission_rate', 'wallet_balance', 'is_available', 'joined_date', 'last_active_at'
    ];

    protected $casts = [
        'latitude' => 'decimal:7',
        'longitude' => 'decimal:7',
        'rating' => 'decimal:2',
        'commission_rate' => 'decimal:2',
        'wallet_balance' => 'decimal:2',
        'is_available' => 'boolean',
        'date_of_birth' => 'date',
        'joined_date' => 'date',
        'last_active_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function vehicles(): HasMany
    {
        return $this->hasMany(DeliveryBoyVehicle::class);
    }

    public function documents(): HasMany
    {
        return $this->hasMany(DeliveryBoyDocument::class);
    }

    public function areas(): HasMany
    {
        return $this->hasMany(DeliveryBoyArea::class);
    }

    public function earnings(): HasMany
    {
        return $this->hasMany(DeliveryBoyEarning::class);
    }

    public function ratings(): HasMany
    {
        return $this->hasMany(DeliveryBoyRating::class);
    }

    public function deliveries(): HasMany
    {
        return $this->hasMany(Delivery::class);
    }
}
