<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Category extends Model
{
    protected $fillable = ['name', 'slug', 'icon', 'is_active', 'sort_order'];

    protected $casts = ['is_active' => 'boolean'];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($category) {
            if (empty($category->slug)) {
                $category->slug = Str::slug($category->name);
            }
        });
    }

    public function products()
    {
        return $this->hasMany(ProductNew::class);
    }

    public function variations()
    {
        return $this->hasMany(CategoryVariation::class);
    }
    
    public function addons()
    {
        return $this->hasMany(CategoryAddon::class);
    }

    public function restaurants()
    {
        return $this->hasManyThrough(
            Restaurant::class,
            ProductNew::class,
            'category_id',
            'id',
            'id',
            'restaurant_id'
        )->distinct();
    }
}
