<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreProductVariantRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'product_id' => ['required', 'exists:products,id'],
            'name' => ['required', 'string', 'max:255'],
            'price' => ['required', 'numeric', 'min:0'],
            'is_default' => ['boolean'],
            'is_active' => ['boolean']
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            // If setting as default, ensure no other default exists
            if ($this->is_default) {
                $existingDefault = \App\Models\ProductVariant::where('product_id', $this->product_id)
                    ->where('is_default', true)
                    ->when($this->route('variant'), function ($query) {
                        $query->where('id', '!=', $this->route('variant')->id);
                    })
                    ->exists();

                if ($existingDefault) {
                    $validator->errors()->add('is_default', 'Another variant is already set as default for this product.');
                }
            }
        });
    }
}
