<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class VerifyDeliveryDocumentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->hasRole('super-admin');
    }

    public function rules(): array
    {
        return [
            'verification_status' => 'required|in:verified,rejected',
            'rejection_reason' => 'required_if:verification_status,rejected|nullable|string|max:500',
        ];
    }

    public function messages(): array
    {
        return [
            'verification_status.required' => 'Verification status is required',
            'verification_status.in' => 'Verification status must be either verified or rejected',
            'rejection_reason.required_if' => 'Rejection reason is required when rejecting documents',
            'rejection_reason.max' => 'Rejection reason cannot exceed 500 characters',
        ];
    }
}
