<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class CreateProductRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'restaurant_id' => 'required|exists:restaurants,id',
            'category_id' => 'required|exists:categories,id',
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'price' => 'required|numeric|min:0',
            'discount_price' => 'nullable|numeric|lt:price|min:0',
            'discount_type' => 'nullable|in:percentage,fixed|required_with:discount_price',
            'image' => 'required|image|max:2048',
            'images' => 'nullable|array|max:5',
            'images.*' => 'image|max:2048',
            'is_available' => 'boolean',
            'is_featured' => 'boolean',
            'is_vegetarian' => 'boolean',
            'is_spicy' => 'boolean',
            'preparation_time' => 'integer|min:1|max:120',
            'sort_order' => 'integer|min:0'
        ];
    }
}