<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class CreateCommissionRuleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'type' => 'required|in:percentage,fixed',
            'value' => 'required|numeric|min:0',
            'status' => 'required|in:active,inactive',
            'commissionable_type' => 'required|string|max:100',
            'commissionable_id' => 'required|integer',
            'min_order_amount' => 'nullable|numeric|min:0',
            'max_order_amount' => 'nullable|numeric|gt:min_order_amount',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date|after:start_date'
        ];
    }
}