<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ProductController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();
        
        // If authenticated admin/manager, delegate to Manager controller
        if ($user) {
            $userRoles = $user->roles->pluck('name')->toArray();
            if (in_array('admin', $userRoles) || in_array('manager', $userRoles)) {
                return app(\App\Http\Controllers\API\Manager\ProductManagementController::class)->index($request);
            }
        }

        // Public view - only show available products
        $query = Product::with(['restaurant', 'category', 'variations', 'addons'])
            ->where('is_available', true);

        if ($request->restaurant_id) {
            $query->where('restaurant_id', $request->restaurant_id);
        }

        if ($request->category_id) {
            $query->where('category_id', $request->category_id);
        }

        if ($request->search) {
            $query->where('name', 'like', "%{$request->search}%");
        }

        $products = $query->paginate(20);

        return response()->json($products);
    }

    public function store(Request $request)
    {
        return app(\App\Http\Controllers\API\Manager\ProductManagementController::class)->store($request);
    }

    public function show($id)
    {
        $product = Product::with(['restaurant', 'category', 'variations', 'addons', 'reviews.user'])
            ->findOrFail($id);

        return response()->json($product);
    }

    public function update(Request $request, $id)
    {
        return app(\App\Http\Controllers\API\Manager\ProductManagementController::class)->update($request, $id);
    }

    public function destroy($id)
    {
        return app(\App\Http\Controllers\API\Manager\ProductManagementController::class)->destroy($id);
    }
}
