<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class DashboardAnalyticsController extends Controller
{
    public function index()
    {
        // Return basic analytics data
        return response()->json([
            'total_orders' => 0,
            'total_revenue' => 0,
            'total_users' => 0,
            'total_restaurants' => 0,
        ]);
    }

    public function revenueChart()
    {
        return response()->json([
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
            'data' => [1000, 1500, 1200, 1800, 2000, 2200],
        ]);
    }

    public function orderChart()
    {
        return response()->json([
            'labels' => ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            'data' => [50, 60, 45, 70, 80, 90, 85],
        ]);
    }

    public function userChart()
    {
        return response()->json([
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
            'data' => [100, 150, 200, 250, 300, 350],
        ]);
    }

    public function topRestaurants()
    {
        return response()->json([]);
    }

    public function topProducts()
    {
        return response()->json([]);
    }

    public function recentOrders()
    {
        return response()->json([]);
    }
}