<?php

namespace App\Http\Controllers\API\Cashier;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function toggleAvailability(Request $request, $id)
    {
        $user = $request->user();
        $product = Product::where('restaurant_id', $user->restaurant_id)->findOrFail($id);
        
        $product->update(['is_available' => !$product->is_available]);

        return response()->json([
            'message' => 'Product availability updated',
            'data' => $product
        ]);
    }

    public function updateStock(Request $request, $id)
    {
        $user = $request->user();
        $product = Product::where('restaurant_id', $user->restaurant_id)->findOrFail($id);
        
        $request->validate(['stock_quantity' => 'required|integer|min:0']);
        
        $product->update([
            'stock_quantity' => $request->stock_quantity,
            'is_available' => $request->stock_quantity > 0
        ]);

        return response()->json([
            'message' => 'Stock updated',
            'data' => $product
        ]);
    }
}
