<?php

namespace App\Http\Controllers\API\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingsManagementController extends Controller
{
    public function index()
    {
        try {
            $settings = Setting::orderBy('group')->orderBy('key')->get()->groupBy('group');
            
            return response()->json(['success' => true, 'data' => $settings]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $setting = Setting::findOrFail($id);
            $setting->update(['value' => $request->value]);
            
            return response()->json(['success' => true, 'message' => 'Setting updated']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    }

    public function bulkUpdate(Request $request)
    {
        try {
            foreach ($request->settings as $item) {
                Setting::where('id', $item['id'])->update(['value' => $item['value']]);
            }
            
            return response()->json(['success' => true, 'message' => 'Settings updated']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    }
}
