<?php

namespace App\Http\Controllers\API\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function index(Request $request)
    {
        $query = Product::with(['restaurant', 'category', 'variations', 'addons'])
            ->when($request->search, fn($q) => $q->where('name', 'like', "%{$request->search}%"))
            ->when($request->category_id, fn($q) => $q->where('category_id', $request->category_id))
            ->when($request->restaurant_id, fn($q) => $q->where('restaurant_id', $request->restaurant_id))
            ->when($request->status, function($q) use ($request) {
                if ($request->status === 'pending') $q->where('is_approved', false);
                if ($request->status === 'approved') $q->where('is_approved', true);
                if ($request->status === 'active') $q->where('is_active', true);
                if ($request->status === 'inactive') $q->where('is_active', false);
            })
            ->latest();

        return response()->json($query->paginate(20));
    }

    public function approve($id)
    {
        $product = Product::findOrFail($id);
        $product->update(['is_approved' => true]);
        return response()->json(['message' => 'Product approved', 'data' => $product]);
    }

    public function reject($id)
    {
        $product = Product::findOrFail($id);
        $product->update(['is_approved' => false]);
        return response()->json(['message' => 'Product rejected', 'data' => $product]);
    }

    public function toggleStatus($id)
    {
        $product = Product::findOrFail($id);
        $product->update(['is_active' => !$product->is_active]);
        return response()->json(['message' => 'Status updated', 'data' => $product]);
    }

    public function destroy($id)
    {
        Product::findOrFail($id)->delete();
        return response()->json(['message' => 'Product deleted']);
    }

    public function analytics($id)
    {
        $product = Product::with(['restaurant', 'category'])->findOrFail($id);
        
        return response()->json([
            'product' => $product,
            'total_orders' => $product->total_orders,
            'total_revenue' => $product->total_orders * $product->price,
            'rating' => $product->rating,
            'total_reviews' => $product->total_reviews
        ]);
    }
}
