<?php

namespace App\Http\Controllers\API\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Restaurant;
use App\Models\User;
use App\Models\Product;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function index()
    {
        try {
            $notifications = [];
            
            // Pending orders
            $pendingOrders = Order::where('status', 'pending')->count();
            if ($pendingOrders > 0) {
                $notifications[] = [
                    'id' => 'pending_orders',
                    'icon' => '📦',
                    'title' => "{$pendingOrders} pending orders",
                    'time' => 'Now',
                    'read' => false
                ];
            }
            
            // Pending restaurants
            $pendingRestaurants = Restaurant::where('status', 'pending')->count();
            if ($pendingRestaurants > 0) {
                $notifications[] = [
                    'id' => 'pending_restaurants',
                    'icon' => '🏪',
                    'title' => "{$pendingRestaurants} restaurants pending approval",
                    'time' => 'Now',
                    'read' => false
                ];
            }
            
            // Pending products
            $pendingProducts = Product::where('is_active', false)->count();
            if ($pendingProducts > 0) {
                $notifications[] = [
                    'id' => 'pending_products',
                    'icon' => '🍕',
                    'title' => "{$pendingProducts} products pending verification",
                    'time' => 'Now',
                    'read' => false
                ];
            }
            
            // New delivery boys
            $newDeliveryBoys = User::whereHas('roles', function($q) {
                $q->where('name', 'delivery-boy');
            })
                ->where('created_at', '>=', now()->subDay())
                ->count();
            if ($newDeliveryBoys > 0) {
                $notifications[] = [
                    'id' => 'new_delivery_boys',
                    'icon' => '🚴',
                    'title' => "{$newDeliveryBoys} new delivery boys registered",
                    'time' => 'Today',
                    'read' => false
                ];
            }
            
            return response()->json(['success' => true, 'data' => $notifications]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    }

    public function markAllRead()
    {
        return response()->json(['success' => true, 'message' => 'All notifications marked as read']);
    }
}
