// Run this in Tinker: php artisan tinker

// Get the manager's restaurant
$user = App\Models\User::where('email', 'manager@test.com')->first();
$restaurant = $user->restaurant;

// Create a product
$product = App\Models\ProductNew::create([
    'restaurant_id' => $restaurant->id,
    'category_id' => 1,
    'name' => 'Chicken Kottu',
    'description' => 'Delicious chicken kottu with vegetables',
    'base_price' => 500,
    'has_variants' => true,
    'is_active' => true
]);

// Add variants
App\Models\ProductVariant::create([
    'product_id' => $product->id,
    'name' => 'Half',
    'price' => 500,
    'is_default' => true,
    'is_active' => true
]);

App\Models\ProductVariant::create([
    'product_id' => $product->id,
    'name' => 'Full',
    'price' => 900,
    'is_default' => false,
    'is_active' => true
]);

echo "Product created successfully!";
