# 🔧 "This site can't be reached" Fix කරන්නේ කොහොමද?

## ✅ Step-by-Step Fix

### 1️⃣ Laravel Server Start කරන්න

**Option A: Batch File Use කරන්න (ඉක්මනින්ම)**
```bash
# Double click කරන්න:
start-mobile-server.bat
```

**Option B: Manual Command**
```bash
cd g:\project\laravel\delivery_system
php artisan serve --host=0.0.0.0 --port=8000
```

**Important:** `--host=0.0.0.0` use කරන්න ඕනේ! `localhost` use කරන්න එපා!

### 2️⃣ Server Run වෙනවද Check කරන්න

Terminal එකේ මේ message එක පෙන්වන්න ඕනේ:
```
INFO  Server running on [http://0.0.0.0:8000].
Press Ctrl+C to stop the server
```

### 3️⃣ Computer Browser එකෙන් Test කරන්න

Computer එකේම browser එක open කරලා:
```
http://localhost:8000/delivery-boy
```

මේක work වෙනවනම්, server එක හරියට run වෙනවා! ✅

### 4️⃣ Phone එකත් Computer එකත් Same WiFi එකේද Check කරන්න

**Computer WiFi:**
- Settings → Network & Internet → WiFi
- Connected network name බලන්න

**Phone WiFi:**
- Settings → WiFi
- Same network එකට connect වෙලා තියෙනවද check කරන්න

**Important:** Mobile data OFF කරන්න phone එකේ!

### 5️⃣ Windows Firewall Allow කරන්න

**Method 1: Firewall Temporarily Disable කරන්න**
```
1. Windows Security open කරන්න
2. Firewall & network protection
3. Private network → Turn off
```

**Method 2: PHP Allow කරන්න Firewall එකේ**
```
1. Windows Defender Firewall → Advanced settings
2. Inbound Rules → New Rule
3. Program → Browse → Select php.exe
   Location: C:\php\php.exe (ඔබේ PHP path එක)
4. Allow the connection
5. Apply
```

### 6️⃣ Phone Browser එකෙන් Access කරන්න

```
http://192.168.8.179:8000/delivery-boy
```

---

## 🔍 Still Not Working? Try These:

### Test 1: Ping Computer from Phone

Phone එකේ terminal app එකක් install කරලා:
```bash
ping 192.168.8.179
```

Reply එනවනම්, network connection එක හරි! ✅

### Test 2: Simple API Test

Computer browser එකෙන්:
```
http://192.168.8.179:8000/api/restaurants
```

Phone browser එකෙන්:
```
http://192.168.8.179:8000/api/restaurants
```

දෙකම work වෙන්න ඕනේ!

### Test 3: Check Laravel Routes

```bash
php artisan route:list | findstr delivery-boy
```

`/delivery-boy` route එක list එකේ තියෙන්න ඕනේ.

### Test 4: Clear Cache

```bash
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

---

## 🚨 Common Issues & Solutions

### Issue 1: "Connection refused"
**Solution:** Server එක `0.0.0.0` host එකෙන් run කරන්න
```bash
php artisan serve --host=0.0.0.0 --port=8000
```

### Issue 2: "Connection timed out"
**Solution:** Firewall allow කරන්න හෝ disable කරන්න

### Issue 3: "ERR_CONNECTION_REFUSED"
**Solution:** 
1. Server එක run වෙනවද check කරන්න
2. Port 8000 already use වෙනවද check කරන්න:
```bash
netstat -ano | findstr :8000
```

### Issue 4: Different WiFi Networks
**Solution:** Phone එකත් computer එකත් same WiFi network එකට connect කරන්න

### Issue 5: Router Isolation
**Solution:** Router settings එකේ "AP Isolation" හෝ "Client Isolation" disable කරන්න

---

## 🎯 Quick Checklist

- [ ] Laravel server run වෙනවද? (`php artisan serve --host=0.0.0.0`)
- [ ] Computer browser එකෙන් work වෙනවද? (`http://localhost:8000/delivery-boy`)
- [ ] Phone එකත් computer එකත් same WiFi එකේද?
- [ ] Phone එකේ mobile data OFF ද?
- [ ] Windows Firewall allow කරලා තියෙනවද?
- [ ] IP address එක correct ද? (`192.168.8.179`)
- [ ] Port 8000 use කරනවද?

---

## 💡 Alternative: Use ngrok (Internet Through)

WiFi issues තියෙනවනම්, ngrok use කරන්න පුළුවන්:

### 1. Download ngrok
```
https://ngrok.com/download
```

### 2. Start Laravel
```bash
php artisan serve
```

### 3. Start ngrok
```bash
ngrok http 8000
```

### 4. Use ngrok URL
```
https://xxxx-xxxx-xxxx.ngrok.io/delivery-boy
```

මේක internet එකෙන් anywhere access කරන්න පුළුවන්! 🌍

---

## 📞 Debug Commands

```bash
# Check server is running
netstat -ano | findstr :8000

# Check IP address
ipconfig

# Test connection
curl http://192.168.8.179:8000/delivery-boy

# Check Laravel logs
type storage\logs\laravel.log

# Check routes
php artisan route:list
```

---

## ✅ Success Indicators

Server හරියට run වෙනවනම්:

1. Terminal එකේ: `Server running on [http://0.0.0.0:8000]`
2. Computer browser: Page load වෙනවා
3. Phone browser: Page load වෙනවා
4. No firewall warnings

---

**Still having issues? මේ info එක share කරන්න:**
1. Error message එක (screenshot)
2. Laravel logs (`storage/logs/laravel.log`)
3. Browser console errors (F12)
4. Server terminal output

**Good luck!** 🚀
