# 🧪 RESTAURANT MODULE - Test Guide

## ✅ Quick Test Steps

### 1. Setup
```bash
php artisan migrate
php artisan db:seed
php artisan serve
```

### 2. Test as Manager

#### Login as Manager
```http
POST http://localhost:8000/api/login
Content-Type: application/json

{
  "email": "manager@test.com",
  "password": "password"
}
```

**Save the token from response!**

#### Create Restaurant
```http
POST http://localhost:8000/api/restaurants
Authorization: Bearer {manager_token}
Content-Type: application/json

{
  "name": "Pizza Paradise",
  "description": "Best pizza in town",
  "phone": "0771234567",
  "email": "info@pizzaparadise.com",
  "address": "123 Main Street, Colombo",
  "latitude": 6.9271,
  "longitude": 79.8612,
  "delivery_radius": 10,
  "opening_time": "10:00",
  "closing_time": "22:00"
}
```

**Expected:** Status 201, restaurant created with status "pending"

#### Get My Restaurants
```http
GET http://localhost:8000/api/my-restaurants
Authorization: Bearer {manager_token}
```

#### Update Restaurant Status
```http
PATCH http://localhost:8000/api/restaurants/1/status
Authorization: Bearer {manager_token}
Content-Type: application/json

{
  "operational_status": "open"
}
```

### 3. Test as Admin

#### Login as Admin
```http
POST http://localhost:8000/api/login
Content-Type: application/json

{
  "email": "admin@test.com",
  "password": "password"
}
```

#### Get Pending Restaurants
```http
GET http://localhost:8000/api/admin/restaurants/pending
Authorization: Bearer {admin_token}
```

#### Approve Restaurant
```http
POST http://localhost:8000/api/admin/restaurants/1/approve
Authorization: Bearer {admin_token}
```

**Expected:** Restaurant status changes to "approved"

#### Suspend Restaurant
```http
POST http://localhost:8000/api/admin/restaurants/1/suspend
Authorization: Bearer {admin_token}
```

### 4. Test as Customer (Public)

#### List Restaurants
```http
GET http://localhost:8000/api/restaurants
```

**Expected:** Only approved restaurants shown

#### Search Restaurants
```http
GET http://localhost:8000/api/restaurants?search=pizza
```

#### Get Restaurant Details
```http
GET http://localhost:8000/api/restaurants/1
```

---

## 📊 Test Checklist

- [ ] Manager can create restaurant
- [ ] Restaurant starts with "pending" status
- [ ] Manager can update own restaurant
- [ ] Manager can change operational status
- [ ] Manager can view own restaurants
- [ ] Admin can see pending restaurants
- [ ] Admin can approve restaurant
- [ ] Admin can suspend restaurant
- [ ] Public can list approved restaurants only
- [ ] Public can search restaurants
- [ ] Public can view restaurant details
- [ ] Unauthorized users get 403 error

---

## 🎯 Expected Behaviors

### Manager Creates Restaurant
- ✅ Status: "pending"
- ✅ Requires admin approval
- ✅ Manager can update details
- ✅ Manager can change open/closed status

### Admin Approves Restaurant
- ✅ Status changes to "approved"
- ✅ Restaurant appears in public list
- ✅ Customers can see and order

### Admin Suspends Restaurant
- ✅ Status changes to "suspended"
- ✅ Restaurant hidden from public
- ✅ No new orders accepted

---

## 🔒 Access Control Tests

### Try as Customer (Should Fail)
```http
POST http://localhost:8000/api/restaurants
Authorization: Bearer {customer_token}
```
**Expected:** 403 Unauthorized

### Try to Update Other's Restaurant (Should Fail)
```http
PUT http://localhost:8000/api/restaurants/999
Authorization: Bearer {manager_token}
```
**Expected:** 404 or 403

---

## ✅ All Tests Pass!

Your Restaurant Management module is working perfectly! 🎉
