# ⚡ Product Management - Quick Start Guide

## 🚀 Getting Started (5 Minutes)

### Step 1: Database Migration ✅
```bash
php artisan migrate
```
Already done! ✓

### Step 2: Start Servers
```bash
# Terminal 1 - Laravel
php artisan serve

# Terminal 2 - Vue
npm run dev
```

### Step 3: Login & Test

#### Test as Restaurant Owner (Manager)
1. Go to: `http://localhost:5173/login`
2. Login: `admin2@fooddelivery.com` / `admin123`
3. Navigate to: **My Products**
4. Click: **Add Product**
5. Fill form:
   - Name: "Chicken Pizza"
   - Category: Select any
   - Price: 1500
   - Upload image
   - Add variation: "Large" - Rs 300
   - Add addon: "Extra Cheese" - Rs 150
6. Click: **Save Product**
7. ✅ Product created (Pending Approval)

#### Test as Super Admin
1. Logout
2. Login: `admin@fooddelivery.com` / `admin123`
3. Navigate to: **Products**
4. Filter: **Pending Approval**
5. Click: **✓ Approve**
6. ✅ Product now visible to customers!

---

## 📋 API Testing (Postman/Insomnia)

### 1. Login
```http
POST http://localhost:8000/api/login
Content-Type: application/json

{
  "email": "admin2@fooddelivery.com",
  "password": "admin123"
}
```
Copy the `token` from response.

### 2. Create Product
```http
POST http://localhost:8000/api/manager/products
Authorization: Bearer {your-token}
Content-Type: multipart/form-data

name: Margherita Pizza
category_id: 1
description: Classic Italian pizza
price: 1200
discount_price: 1000
stock_quantity: 50
preparation_time: 20
is_vegetarian: true
is_spicy: false
variations: [{"name":"Small","price":0},{"name":"Large","price":400}]
addons: [{"name":"Extra Cheese","price":150}]
image: <upload file>
```

### 3. List Products
```http
GET http://localhost:8000/api/manager/products
Authorization: Bearer {your-token}
```

### 4. Approve Product (Super Admin)
```http
POST http://localhost:8000/api/admin/products/1/approve
Authorization: Bearer {super-admin-token}
```

---

## 🎯 Common Tasks

### Add Product with Variations
```javascript
// Frontend form data
{
  name: "Burger",
  category_id: 2,
  price: 800,
  variations: [
    { name: "Regular", price: 0 },
    { name: "Large", price: 200 },
    { name: "Extra Large", price: 400 }
  ],
  addons: [
    { name: "Cheese", price: 100 },
    { name: "Bacon", price: 150 }
  ]
}
```

### Toggle Availability
```http
POST /api/manager/products/1/toggle-availability
```

### Update Stock
```http
POST /api/manager/products/1/update-stock
Content-Type: application/json

{
  "stock_quantity": 25
}
```

---

## 🔍 Troubleshooting

### Product not visible to customers?
Check:
- [ ] is_approved = true (Admin approved?)
- [ ] is_active = true (Manager enabled?)
- [ ] is_available = true (In stock?)
- [ ] stock_quantity > 0

### Image not uploading?
- Check file size < 2MB
- Check file type (jpg, png, gif)
- Check storage/app/public linked: `php artisan storage:link`

### 403 Forbidden?
- Check user role
- Check restaurant_id assigned
- Check token valid

---

## 📊 Database Quick Check

```sql
-- Check product status
SELECT id, name, is_approved, is_active, is_available, stock_quantity 
FROM products;

-- Check pending products
SELECT * FROM products WHERE is_approved = 0;

-- Check product with variations
SELECT p.name, pv.name as variation, pv.price_adjustment
FROM products p
LEFT JOIN product_variations pv ON p.id = pv.product_id;
```

---

## 🎨 UI Routes

```
Super Admin:
/admin/products - Product approval & management

Manager/Admin:
/manager/products - My products CRUD

Customer:
/restaurants/{id} - View restaurant products
```

---

## ✅ Verification Checklist

- [x] Migration successful
- [x] Controllers created
- [x] Routes configured
- [x] Frontend pages working
- [x] Image upload working
- [x] Variations working
- [x] Add-ons working
- [x] Approval workflow working
- [x] Role-based access working
- [x] Search & filter working

---

## 🎉 You're Ready!

The product management system is fully functional and production-ready!

**Need help?** Check `PRODUCT_MANAGEMENT_DOCS.md` for detailed documentation.
