# Navbar Component Usage Guide

## Navbar Component එක හදලා තියෙනවා!

Location: `resources/js/components/Navbar.vue`

## Features:
- 🍔 Logo (clickable - home එකට යනවා)
- 🏠 Navigation links (Home, Restaurants, My Orders)
- 📍 Location button (Colombo)
- 🛒 Cart icon with badge (item count)
- 👤 User menu dropdown
- 📱 Mobile responsive menu

## හැම page එකටම Navbar එක දාන්න:

### 1. Home Page (දැනටමත් තියෙනවා)
```vue
<template>
  <div>
    <Navbar />
    <!-- Rest of your content -->
  </div>
</template>

<script setup>
import Navbar from '../../components/Navbar.vue';
</script>
```

### 2. Profile Page
File: `resources/js/views/Profile.vue`

Replace header with:
```vue
<template>
  <div class="min-h-screen bg-gray-50">
    <Navbar />
    <!-- Rest of content -->
  </div>
</template>

<script setup>
import Navbar from '../components/Navbar.vue';
// ... rest of imports
</script>
```

### 3. Cart Page
File: `resources/js/views/Cart.vue`

Replace header with:
```vue
<template>
  <div class="min-h-screen bg-gray-50">
    <Navbar />
    <!-- Rest of content -->
  </div>
</template>

<script setup>
import Navbar from '../components/Navbar.vue';
// ... rest of imports
</script>
```

### 4. Orders Page
File: `resources/js/views/Orders/Index.vue`

Replace header with:
```vue
<template>
  <div class="min-h-screen bg-gray-50">
    <Navbar />
    <!-- Rest of content -->
  </div>
</template>

<script setup>
import Navbar from '../../components/Navbar.vue';
// ... rest of imports
</script>
```

### 5. Restaurants Page
File: `resources/js/views/Restaurants/Index.vue`

Replace header with:
```vue
<template>
  <div class="min-h-screen bg-gray-50">
    <Navbar />
    <!-- Rest of content -->
  </div>
</template>

<script setup>
import Navbar from '../../components/Navbar.vue';
// ... rest of imports
</script>
```

## Navbar Component Features:

### Desktop:
- Logo + Navigation Links + Location + Cart + User Menu

### Mobile:
- Logo + Cart + User Menu + Hamburger Menu
- Hamburger click කරද්දී navigation links පෙනෙනවා

### User Menu (Logged In):
- My Profile
- My Orders
- My Cart
- My Wallet
- Logout

### User Menu (Not Logged In):
- Login
- Sign Up

## Cart Badge:
- Cart එකේ items count එක automatically පෙන්වනවා
- Orange badge with white text
- Cart empty නම් badge එක hide වෙනවා

## Navigation Links:
- Active link එක orange color එකෙන් highlight වෙනවා
- Hover effects තියෙනවා

## Mobile Menu:
- Hamburger icon click කරද්දී menu open වෙනවා
- Link එකක් click කරද්දී menu close වෙනවා

---

**දැන් Navbar component එක ready! හැම page එකටම import කරලා use කරන්න පුළුවන්! 🎉**
