# 🔐 Login Guide - Super Admin Dashboard

## 🚀 Quick Start

### 1️⃣ Start Backend (Laravel)
```bash
cd g:\project\laravel\delivery_system
php artisan serve
```
**Backend URL:** `http://127.0.0.1:8000`

### 2️⃣ Start Frontend (Vue.js)
```bash
cd g:\project\laravel\delivery_system
npm run dev
```
**Frontend URL:** `http://localhost:5173`

---

## 🔑 Login Credentials

### Super Admin (Full Access)
```
Email: admin@fooddelivery.com
Password: admin123
Dashboard: http://localhost:5173/super-admin
```

### Admin (Restaurant Owner)
```
Email: admin2@fooddelivery.com
Password: admin123
Dashboard: http://localhost:5173/admin/dashboard
```

### Manager
```
Email: manager@fooddelivery.com
Password: manager123
Dashboard: http://localhost:5173/manager/dashboard
```

### Delivery Boy
```
Email: delivery@fooddelivery.com
Password: delivery123
Dashboard: http://localhost:5173/delivery/dashboard
```

### Customer
```
Email: customer@fooddelivery.com
Password: customer123
Dashboard: http://localhost:5173/customer/dashboard
```

---

## 📱 Login Steps

### Step 1: Open Browser
```
http://localhost:5173/login
```

### Step 2: Enter Credentials
- Email: `admin@fooddelivery.com`
- Password: `admin123`

### Step 3: Click Login
Auto-redirect වෙයි role එකට අනුව:
- **Super Admin** → `/super-admin`
- **Admin** → `/admin/dashboard`
- **Manager** → `/manager/dashboard`
- **Delivery Boy** → `/delivery/dashboard`
- **Customer** → `/restaurants`

---

## ⚠️ Important URLs

| Service | URL | Port |
|---------|-----|------|
| Laravel Backend | `http://127.0.0.1:8000` | 8000 |
| Vue Frontend | `http://localhost:5173` | 5173 |
| Login Page | `http://localhost:5173/login` | 5173 |
| Super Admin | `http://localhost:5173/super-admin` | 5173 |

---

## 🔧 Troubleshooting

### Login වෙන්නේ නැත්නම්:

**1. Backend running ද check කරන්න:**
```bash
curl http://127.0.0.1:8000/api/user
```

**2. Database seeded ද check කරන්න:**
```bash
php artisan db:seed --class=RolePermissionSeeder
```

**3. Cache clear කරන්න:**
```bash
php artisan cache:clear
php artisan config:clear
```

**4. Browser console check කරන්න:**
```
F12 → Console → Check for errors
```

### "401 Unauthorized" error නම්:
```bash
# .env file check කරන්න
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=delivery_system
DB_USERNAME=root
DB_PASSWORD=

# Migrate again
php artisan migrate:fresh --seed
```

### Frontend connect වෙන්නේ නැත්නම්:
```bash
# Check .env file
VITE_API_URL=http://127.0.0.1:8000

# Restart dev server
npm run dev
```

---

## 🎯 After Login

### Super Admin Dashboard Features:
✅ View statistics  
✅ Manage restaurants  
✅ Manage orders  
✅ Manage payments  
✅ Manage users  
✅ System settings  
✅ View charts  

### Quick Actions:
- 🏪 Restaurants → `/super-admin/restaurants`
- 📦 Orders → `/super-admin/orders`
- 💳 Payments → `/super-admin/payments`
- 👥 Users → `/super-admin/users`
- ⚙️ Settings → `/super-admin/settings`

---

## 📝 Test Login Flow

```bash
# 1. Start servers
php artisan serve
npm run dev

# 2. Open browser
http://localhost:5173/login

# 3. Login as Super Admin
Email: admin@fooddelivery.com
Password: admin123

# 4. Should redirect to
http://localhost:5173/super-admin

# 5. Check dashboard loads
✅ Stats cards visible
✅ Charts rendering
✅ Quick actions working
```

---

## 🔐 Security Notes

- Passwords are bcrypt hashed
- API uses Laravel Sanctum tokens
- Role-based access control (RBAC)
- Route guards protect admin pages
- Token stored in localStorage

---

**Login වෙලා Super Admin Dashboard එක access කරන්න!** 🚀
