# 🚀 How to Use Restaurant Orders Feature

## Method 1: Event-Based (Recommended - Already Integrated)

### Add this ONE line to any button:

```vue
<button @click="window.dispatchEvent(new CustomEvent('open-restaurant-orders', { detail: { restaurantId: 5 } }))">
  View Orders
</button>
```

### Or create a function:

```vue
<template>
  <button @click="viewOrders(restaurant.id)">View Orders</button>
</template>

<script setup>
const viewOrders = (id) => {
  window.dispatchEvent(new CustomEvent('open-restaurant-orders', { detail: { restaurantId: id } }))
}
</script>
```

## Method 2: Direct Import

```vue
<template>
  <div>
    <button @click="showModal = true; restaurantId = 5">View Orders</button>
    
    <RestaurantOrdersModal 
      :isOpen="showModal" 
      :restaurantId="restaurantId" 
      @close="showModal = false" 
    />
  </div>
</template>

<script setup>
import { ref } from 'vue'
import RestaurantOrdersModal from '@/components/SuperAdmin/RestaurantOrdersModal.vue'

const showModal = ref(false)
const restaurantId = ref(null)
</script>
```

## ✅ Already Working In:

1. **OrderManagement.vue** - When you select a restaurant from dropdown, click "View Restaurant Orders" button
2. **Layout.vue** - Modal is integrated, just dispatch the event from anywhere

## 🎯 Quick Test

Open browser console and run:
```javascript
window.dispatchEvent(new CustomEvent('open-restaurant-orders', { detail: { restaurantId: 1 } }))
```

The modal should open immediately!

## 📋 What You Get:

- ✅ Restaurant name + stats in header
- ✅ Search orders by ID/customer
- ✅ Filter by status
- ✅ Filter by date range
- ✅ Change order status (dropdown)
- ✅ Assign delivery boy
- ✅ View full order details
- ✅ Cancel orders
- ✅ Pagination (10/20/50 per page)

## 🔧 Where to Add Button:

### In Restaurant Cards:
```vue
<div class="restaurant-card">
  <h3>{{ restaurant.name }}</h3>
  <button @click="viewOrders(restaurant.id)">📦 View Orders</button>
</div>
```

### In Restaurant Table:
```vue
<tr v-for="restaurant in restaurants">
  <td>{{ restaurant.name }}</td>
  <td>
    <button @click="viewOrders(restaurant.id)">View Orders</button>
  </td>
</tr>
```

### In Restaurant Management:
```vue
<button @click="viewOrders(restaurant.id)" class="action-btn">
  📦 Orders
</button>
```

That's it! No routing, no complex setup. Just one function call.
