# 🍔 Food Delivery System - සම්පූර්ණ විස්තරය / Complete Overview

## 📌 මූලික අදහස / Core Concept

මේක **Uber Eats / PickMe Food** වගේ professional food delivery platform එකක්. Laravel 10 (Backend) සහ Vue 3 (Frontend) භාවිතා කරලා හදපු production-ready system එකක්.

---

## 🎯 User Roles - භාවිතා කරන්නන්ගේ වර්ග

### 1. **Super Admin** (සුපිරි පරිපාලක)
- සම්පූර්ණ system එකේ පාලනය
- සියලුම restaurants, users, orders manage කරනවා
- Financial reports, commissions, payouts
- System settings සහ configurations

### 2. **Admin** (පරිපාලක)
- Restaurants approve/suspend කරනවා
- Orders monitor කරනවා
- Delivery boys manage කරනවා
- Reports සහ analytics බලනවා

### 3. **Manager** (අවන්හල් කළමනාකරු)
- තමන්ගේ restaurant එක manage කරනවා
- Products, categories, addons add/edit කරනවා
- Orders accept/reject කරනවා
- Restaurant analytics බලනවා

### 4. **Cashier** (මුදල් භාරකරු)
- Orders process කරනවා
- Order status update කරනවා
- Product availability manage කරනවා

### 5. **Delivery Boy** (බෙදාහරින්නා)
- Available deliveries බලනවා
- Deliveries accept/reject කරනවා
- Real-time location tracking
- Earnings සහ wallet manage කරනවා

### 6. **Customer** (පාරිභෝගික)
- Restaurants browse කරනවා
- Food order කරනවා
- Orders track කරනවා
- Reviews සහ ratings දෙනවා

---

## 🏗️ System Architecture - පද්ධති ව්‍යුහය

```
┌─────────────────────────────────────────────────────────────┐
│                    FRONTEND (Vue 3)                         │
│  ┌──────────┐  ┌──────────┐  ┌──────────┐  ┌──────────┐   │
│  │  Home    │  │Restaurant│  │   Cart   │  │  Orders  │   │
│  │  Page    │  │  Menu    │  │ Checkout │  │ Tracking │   │
│  └──────────┘  └──────────┘  └──────────┘  └──────────┘   │
│                                                              │
│  ┌──────────────────────────────────────────────────────┐  │
│  │         Pinia Stores (State Management)              │  │
│  │  - Auth Store  - Cart Store  - Order Store           │  │
│  └──────────────────────────────────────────────────────┘  │
└─────────────────────────────────────────────────────────────┘
                            ↕ Axios HTTP
┌─────────────────────────────────────────────────────────────┐
│                  BACKEND (Laravel 10)                        │
│  ┌──────────────────────────────────────────────────────┐  │
│  │              API Routes (Sanctum Auth)               │  │
│  └──────────────────────────────────────────────────────┘  │
│                            ↓                                 │
│  ┌──────────────────────────────────────────────────────┐  │
│  │                   Controllers                         │  │
│  │  - AuthController  - RestaurantController            │  │
│  │  - OrderController - DeliveryController              │  │
│  └──────────────────────────────────────────────────────┘  │
│                            ↓                                 │
│  ┌──────────────────────────────────────────────────────┐  │
│  │                    Services                           │  │
│  │  - OrderService  - MapService                        │  │
│  │  - DeliveryBoyService  - FinancialService            │  │
│  └──────────────────────────────────────────────────────┘  │
│                            ↓                                 │
│  ┌──────────────────────────────────────────────────────┐  │
│  │                     Models                            │  │
│  │  - User  - Restaurant  - Order  - Product            │  │
│  └──────────────────────────────────────────────────────┘  │
│                            ↓                                 │
│  ┌──────────────────────────────────────────────────────┐  │
│  │              MySQL Database (15+ Tables)             │  │
│  └──────────────────────────────────────────────────────┘  │
└─────────────────────────────────────────────────────────────┘
```

---

## 📊 Database Structure - දත්ත සමුදාය ව්‍යුහය

### Core Tables (මූලික වගු)

#### 1. **users** - භාවිතා කරන්නන්
```
- id, name, email, phone, password
- address, avatar, restaurant_id
- role (via Spatie Permission)
- status (active/blocked)
```

#### 2. **restaurants** - අවන්හල්
```
- id, user_id, name, slug, description
- phone, email, address
- latitude, longitude, delivery_radius
- minimum_order, delivery_fee
- opening_time, closing_time
- status (pending/approved/suspended)
- is_blocked, blocked_reason
- commission_rate, monthly_fee
```

#### 3. **products** - ආහාර
```
- id, restaurant_id, category_id
- name, slug, description, image
- price, discount, preparation_time
- is_available, is_active
```

#### 4. **product_variations** - විවිධ ප්‍රමාණ
```
- id, product_id, name (Small/Medium/Large)
- price_adjustment
```

#### 5. **product_addons** - අමතර දේවල්
```
- id, product_id, name (Extra Cheese, Toppings)
- price
```

#### 6. **categories** - කාණ්ඩ
```
- id, name, slug, icon, description
- is_active, sort_order
```

#### 7. **carts** - කරත්ත
```
- id, user_id, product_id, restaurant_id
- quantity, price
- variation_id, addons (JSON)
- special_notes
```

#### 8. **orders** - ඇණවුම්
```
- id, order_number, user_id, restaurant_id
- status (pending/accepted/preparing/ready/picked_up/delivered/cancelled)
- delivery_address, delivery_latitude, delivery_longitude
- subtotal, delivery_fee, service_charge, tax, discount, total
- distance_km, estimated_delivery_time
- payment_method, payment_status
- customer_notes, kitchen_notes, delivery_notes
- accepted_at, preparing_at, ready_at, picked_up_at, delivered_at
- refund_amount, refund_reason, refund_status
```

#### 9. **order_items** - ඇණවුම් අයිතම
```
- id, order_id, product_id
- name, quantity, price, subtotal
- variation, addons (JSON)
- special_notes
```

#### 10. **deliveries** - බෙදාහැරීම්
```
- id, order_id, delivery_boy_id
- status (assigned/accepted/picked_up/delivered)
- pickup_latitude, pickup_longitude
- delivery_latitude, delivery_longitude
- distance_km, delivery_fee
- assigned_at, accepted_at, picked_up_at, delivered_at
```

#### 11. **delivery_boys** - බෙදාහරින්නන්
```
- id, user_id, vehicle_type, vehicle_number
- license_number, is_online, is_available
- current_latitude, current_longitude
- total_deliveries, rating
- wallet_balance, commission_rate
```

#### 12. **payments** - ගෙවීම්
```
- id, order_id, user_id
- amount, payment_method (cash/card/wallet)
- payment_status, transaction_id
- paid_at
```

#### 13. **wallets** - පසුම්බි
```
- id, user_id, balance
- total_earned, total_withdrawn
```

#### 14. **wallet_transactions** - පසුම්බි ගනුදෙනු
```
- id, wallet_id, type (credit/debit)
- amount, description, reference_id
```

#### 15. **reviews** - සමාලෝචන
```
- id, user_id, order_id, restaurant_id
- rating (1-5), comment
- is_approved
```

### Advanced Tables (උසස් වගු)

#### 16. **order_status_histories** - ඇණවුම් තත්ව ඉතිහාසය
```
- id, order_id, old_status, new_status
- changed_by, changed_at, notes
```

#### 17. **order_financials** - ඇණවුම් මූල්‍ය
```
- id, order_id
- restaurant_earnings, platform_commission
- delivery_boy_earnings, tax_amount
```

#### 18. **order_audit_trails** - ඇණවුම් විගණන මාර්ග
```
- id, order_id, action, user_id
- old_data, new_data, ip_address
```

#### 19. **promo_codes** - ප්‍රවර්ධන කේත
```
- id, code, discount_type, discount_value
- min_order_amount, max_discount
- valid_from, valid_to, usage_limit
```

#### 20. **delivery_boy_locations** - බෙදාහරින්නන්ගේ ස්ථාන
```
- id, delivery_boy_id
- latitude, longitude
- recorded_at
```

---

## 🔄 Order Flow - ඇණවුම් ප්‍රවාහය

### Customer Side (පාරිභෝගික පැත්ත)

```
1. Browse Restaurants → Restaurants list එක බලනවා
   ↓
2. Select Restaurant → Restaurant එකක් තෝරනවා
   ↓
3. View Menu → Menu එක බලනවා (Categories, Products)
   ↓
4. Add to Cart → Products cart එකට දානවා
   - Select variations (Size)
   - Select addons (Extra cheese)
   - Add special notes
   ↓
5. View Cart → Cart එක review කරනවා
   ↓
6. Checkout → Order place කරනවා
   - Enter delivery address
   - Select payment method
   - Apply promo code
   ↓
7. Order Placed → Order confirm වෙනවා
   Status: PENDING
```

### Restaurant Side (අවන්හල් පැත්ත)

```
8. New Order Alert → නව ඇණවුමක් ලැබෙනවා
   ↓
9. Accept Order → ඇණවුම accept කරනවා
   Status: ACCEPTED
   ↓
10. Start Preparing → ආහාර හදන්න පටන් ගන්නවා
    Status: PREPARING
    ↓
11. Food Ready → ආහාර සූදානම්
    Status: READY
```

### Delivery Side (බෙදාහැරීම් පැත්ත)

```
12. Assign Delivery Boy → Delivery boy කෙනෙක් assign කරනවා
    - Auto-assign (nearest available)
    - Manual assign
    ↓
13. Accept Delivery → Delivery boy accept කරනවා
    Status: ACCEPTED
    ↓
14. Pick Up Food → ආහාර collect කරනවා
    Status: PICKED_UP
    ↓
15. Deliver → Customer ට deliver කරනවා
    Status: DELIVERED
    ↓
16. Complete → Order complete වෙනවා
    - Payment processed
    - Commissions calculated
    - Wallet updated
```

---

## 💰 Financial System - මූල්‍ය පද්ධතිය

### Order Amount Breakdown (ඇණවුම් මුදල් බෙදීම)

```
Subtotal (Products)         : Rs 1000.00
+ Delivery Fee              : Rs   50.00
+ Service Charge (5%)       : Rs   50.00
+ Tax (10%)                 : Rs  100.00
- Discount (Promo Code)     : Rs  100.00
─────────────────────────────────────────
Total Amount                : Rs 1100.00
```

### Commission Distribution (කොමිස් බෙදීම)

```
Total Order: Rs 1100.00

Restaurant Earnings:
  Subtotal                  : Rs 1000.00
  - Platform Commission (15%): Rs  150.00
  ─────────────────────────────────────
  Restaurant Gets           : Rs  850.00

Platform Earnings:
  Commission                : Rs  150.00
  Service Charge            : Rs   50.00
  ─────────────────────────────────────
  Platform Gets             : Rs  200.00

Delivery Boy Earnings:
  Delivery Fee              : Rs   50.00
  - Platform Cut (20%)      : Rs   10.00
  ─────────────────────────────────────
  Delivery Boy Gets         : Rs   40.00
```

---

## 🗺️ Map & Location Features - සිතියම් විශේෂාංග

### 1. **Restaurant Location** (අවන්හල් ස්ථානය)
- Latitude, Longitude store කරනවා
- Delivery radius set කරනවා (උදා: 5km)
- Google Maps integration

### 2. **Distance Calculation** (දුර ගණනය)
- Haversine formula භාවිතා කරනවා
- Restaurant → Customer distance
- Delivery fee calculate කරනවා

### 3. **Delivery Boy Tracking** (බෙදාහරින්නා ලුහුබැඳීම)
- Real-time location updates
- GPS coordinates store කරනවා
- Customer ට live tracking පෙන්වනවා

### 4. **Nearest Delivery Boy** (ළඟම බෙදාහරින්නා)
- Available delivery boys filter කරනවා
- Distance calculate කරලා nearest එක තෝරනවා
- Auto-assign feature

---

## 🔐 Authentication & Security - සත්‍යාපනය සහ ආරක්ෂාව

### Laravel Sanctum API Authentication

```php
// Login
POST /api/login
{
  "email": "customer@example.com",
  "password": "password"
}

Response:
{
  "token": "1|abc123...",
  "user": { ... }
}

// Protected Routes
Headers: {
  "Authorization": "Bearer 1|abc123..."
}
```

### Role-Based Access Control (Spatie Permission)

```php
// Middleware
Route::middleware('role:admin')->group(function () {
    // Admin only routes
});

Route::middleware('role:manager|admin')->group(function () {
    // Manager or Admin routes
});
```

---

## 📱 Frontend Structure - ඉදිරිපස ව්‍යුහය

### Vue 3 Components

```
resources/js/
├── components/
│   ├── SuperAdmin/          # Super Admin components
│   │   ├── ComprehensiveDashboard.vue
│   │   ├── RestaurantManagementTable.vue
│   │   ├── OrderManagement.vue
│   │   └── DeliveryBoyManagement.vue
│   ├── Manager/             # Manager components
│   │   ├── Dashboard.vue
│   │   ├── Products.vue
│   │   ├── Orders.vue
│   │   └── Categories.vue
│   └── Customer/            # Customer components
│       ├── RestaurantCard.vue
│       ├── ProductCard.vue
│       └── CartItem.vue
├── views/
│   ├── Customer/
│   │   ├── Home.vue         # මෙතන තමයි ඔබ දැන් ඉන්නේ
│   │   ├── Dashboard.vue
│   │   └── ...
│   ├── Restaurants/
│   │   ├── Index.vue
│   │   ├── Show.vue
│   │   └── Menu.vue
│   ├── Orders/
│   │   ├── Index.vue
│   │   └── Show.vue
│   └── Auth/
│       ├── Login.vue
│       └── Register.vue
├── stores/                  # Pinia State Management
│   ├── auth.js             # Authentication state
│   ├── cart.js             # Shopping cart state
│   └── order.js            # Order state
├── router/
│   └── index.js            # Vue Router configuration
└── services/
    ├── api.js              # Axios API client
    ├── auth.js             # Auth service
    └── restaurant.js       # Restaurant service
```

### Current Home.vue Structure (දැනට ඇති Home.vue ව්‍යුහය)

```vue
<template>
  <!-- Header -->
  <header>
    - Logo: FoodHub
    - Location: Colombo
    - User Profile Icon
  </header>

  <!-- Hero Section -->
  <div class="hero">
    - Title: "Welcome to Food Delivery"
    - Search Bar: Search restaurants/dishes
  </div>

  <!-- Categories -->
  <div class="categories">
    - All, Pizza, Burger, Chinese, etc.
    - Horizontal scroll
  </div>

  <!-- Restaurants Grid -->
  <div class="restaurants">
    - Restaurant cards (4 columns)
    - Image, Name, Rating, Delivery time
    - Click → Go to restaurant page
  </div>

  <!-- Bottom Navigation (Mobile) -->
  <nav>
    - Home, Search, Cart, Profile
  </nav>
</template>

<script>
- search: Search query
- selectedCategory: Selected category filter
- categories: List of categories
- restaurants: List of restaurants
- filteredRestaurants: Filtered by search & category
- loading: Loading state
</script>
```

---

## 🚀 Key Features - ප්‍රධාන විශේෂාංග

### 1. **Smart Cart System**
- Multi-restaurant restriction (එක restaurant එකෙන් විතරක්)
- Variations & addons support
- Special notes
- Auto price calculation
- LocalStorage + Database sync

### 2. **Real-Time Order Tracking**
- Order status updates
- Delivery boy location tracking
- Estimated delivery time
- Push notifications

### 3. **Advanced Product System**
- Categories & subcategories
- Variations (Size, Spice level)
- Add-ons (Toppings, extras)
- Availability control
- Stock management

### 4. **Commission System**
- Restaurant commission (15%)
- Delivery boy commission (20%)
- Platform earnings
- Automatic calculation
- Payout management

### 5. **Review & Rating System**
- Restaurant ratings
- Delivery boy ratings
- Customer reviews
- Admin moderation

### 6. **Promo Code System**
- Percentage/Fixed discount
- Minimum order amount
- Usage limits
- Expiry dates
- User-specific codes

### 7. **Wallet System**
- Digital wallet for users
- Add funds
- Order payments
- Delivery boy earnings
- Transaction history

### 8. **Admin Dashboard**
- Total orders & revenue
- Active users
- Restaurant analytics
- Delivery boy performance
- Financial reports
- Export to CSV/PDF

---

## 🔧 API Endpoints - API අන්ත ලක්ෂ්‍ය

### Public Routes (ප්‍රසිද්ධ මාර්ග)

```
POST   /api/register              # Register new user
POST   /api/login                 # Login
GET    /api/restaurants           # List restaurants
GET    /api/restaurants/{id}      # Restaurant details
GET    /api/products              # List products
GET    /api/products/{id}         # Product details
```

### Customer Routes (පාරිභෝගික මාර්ග)

```
GET    /api/cart                  # View cart
POST   /api/cart                  # Add to cart
PUT    /api/cart/{id}             # Update cart item
DELETE /api/cart/{id}             # Remove from cart
POST   /api/orders                # Place order
GET    /api/orders                # My orders
GET    /api/orders/{id}           # Order details
GET    /api/orders/{id}/track     # Track order
POST   /api/reviews               # Add review
```

### Manager Routes (කළමනාකරු මාර්ග)

```
GET    /api/manager/products      # List products
POST   /api/manager/products      # Add product
PUT    /api/manager/products/{id} # Update product
DELETE /api/manager/products/{id} # Delete product
GET    /api/manager/categories    # List categories
POST   /api/manager/categories    # Add category
GET    /api/manager/addons        # List addons
POST   /api/manager/addons        # Add addon
```

### Admin Routes (පරිපාලක මාර්ග)

```
GET    /api/admin/dashboard       # Dashboard stats
GET    /api/admin/restaurants     # Manage restaurants
POST   /api/admin/restaurants/{id}/approve  # Approve restaurant
POST   /api/admin/restaurants/{id}/suspend  # Suspend restaurant
GET    /api/admin/orders          # All orders
GET    /api/admin/users           # Manage users
GET    /api/admin/delivery-boys   # Manage delivery boys
GET    /api/admin/earnings        # Financial reports
```

### Delivery Boy Routes (බෙදාහරින්නා මාර්ග)

```
GET    /api/delivery-boy/dashboard        # Dashboard
POST   /api/delivery-boy/status           # Update online status
GET    /api/delivery-boy/available        # Available deliveries
GET    /api/delivery-boy/my-deliveries    # My deliveries
POST   /api/deliveries/{id}/accept        # Accept delivery
PUT    /api/deliveries/{id}/status        # Update delivery status
POST   /api/delivery-boy/location         # Update location
```

---

## 🎨 UI/UX Features - UI/UX විශේෂාංග

### Design System
- **Colors**: Orange theme (Food industry standard)
- **Typography**: Clean, readable fonts
- **Icons**: SVG icons (Heroicons)
- **Responsive**: Mobile-first design
- **Animations**: Smooth transitions

### Components
- **Cards**: Restaurant cards, Product cards
- **Modals**: Order details, Confirmations
- **Forms**: Login, Register, Checkout
- **Tables**: Admin data tables
- **Charts**: Revenue charts, Order charts

### User Experience
- **Loading States**: Skeleton loaders
- **Error Handling**: Toast notifications
- **Empty States**: No data messages
- **Search**: Real-time search
- **Filters**: Category filters, Sort options

---

## 📦 Installation & Setup - ස්ථාපනය සහ සැකසුම

### Backend Setup

```bash
# Install dependencies
composer install

# Environment setup
cp .env.example .env
php artisan key:generate

# Database setup
php artisan migrate
php artisan db:seed

# Storage link
php artisan storage:link

# Start server
php artisan serve
```

### Frontend Setup

```bash
# Install dependencies
npm install

# Development
npm run dev

# Production build
npm run build
```

### Create Test Users

```bash
php artisan tinker

# Super Admin
User::create([
    'name' => 'Super Admin',
    'email' => 'superadmin@example.com',
    'password' => bcrypt('password'),
    'phone' => '0771234567'
])->assignRole('super-admin');

# Manager
User::create([
    'name' => 'Restaurant Manager',
    'email' => 'manager@example.com',
    'password' => bcrypt('password'),
    'phone' => '0771234568'
])->assignRole('manager');

# Customer
User::create([
    'name' => 'Customer',
    'email' => 'customer@example.com',
    'password' => bcrypt('password'),
    'phone' => '0771234569'
])->assignRole('customer');
```

---

## 🧪 Testing - පරීක්ෂණය

### Test Credentials (පරීක්ෂණ අක්තපත්‍ර)

```
Super Admin:
Email: superadmin@example.com
Password: password

Manager:
Email: manager@example.com
Password: password

Customer:
Email: customer@example.com
Password: password

Delivery Boy:
Email: delivery@example.com
Password: password
```

### Test Flow (පරීක්ෂණ ප්‍රවාහය)

1. **Customer Flow**
   - Login as customer
   - Browse restaurants
   - Add items to cart
   - Place order
   - Track order

2. **Manager Flow**
   - Login as manager
   - View new orders
   - Accept order
   - Update status to preparing
   - Mark as ready

3. **Delivery Boy Flow**
   - Login as delivery boy
   - View available deliveries
   - Accept delivery
   - Update location
   - Mark as delivered

4. **Admin Flow**
   - Login as admin
   - View dashboard
   - Monitor all orders
   - Manage restaurants
   - View financial reports

---

## 🔍 Common Issues & Solutions - පොදු ගැටළු සහ විසඳුම්

### Issue 1: CORS Error
```
Solution: Check config/cors.php
'paths' => ['api/*'],
'allowed_origins' => ['http://localhost:5173'],
```

### Issue 2: 401 Unauthorized
```
Solution: Check token in localStorage
Headers: Authorization: Bearer {token}
```

### Issue 3: Database Connection Error
```
Solution: Check .env file
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=delivery_system
DB_USERNAME=root
DB_PASSWORD=
```

### Issue 4: Vite Not Running
```
Solution:
npm install
npm run dev
```

---

## 📚 Learning Resources - ඉගෙනීමේ සම්පත්

### Laravel Documentation
- https://laravel.com/docs/10.x
- Eloquent ORM
- Sanctum Authentication
- Migrations & Seeders

### Vue 3 Documentation
- https://vuejs.org/guide/
- Composition API
- Vue Router
- Pinia State Management

### Tailwind CSS
- https://tailwindcss.com/docs
- Utility classes
- Responsive design
- Custom components

---

## 🎯 Next Steps - ඊළඟ පියවර

### What You Can Do Now:

1. **Explore the Code**
   - Read through models
   - Check controllers
   - Review Vue components

2. **Customize Home Page**
   - Change colors
   - Add new sections
   - Modify layout

3. **Add New Features**
   - Favorites system
   - Order history filters
   - Advanced search

4. **Improve UI/UX**
   - Better animations
   - Loading states
   - Error messages

5. **Test Everything**
   - Place test orders
   - Try different roles
   - Check mobile view

---

## 💡 Tips for Development - සංවර්ධනය සඳහා උපදෙස්

1. **Always check the API routes** - routes/api.php
2. **Use Vue DevTools** - Browser extension
3. **Check Laravel logs** - storage/logs/laravel.log
4. **Use Postman** - Test API endpoints
5. **Read error messages carefully** - They tell you what's wrong
6. **Git commit frequently** - Save your progress
7. **Test on mobile** - Responsive design is important
8. **Ask for help** - Don't struggle alone

---

## 📞 Support - සහාය

If you need help:
1. Check this documentation
2. Read Laravel/Vue docs
3. Check error logs
4. Search on Google/Stack Overflow
5. Ask me! 😊

---

**Built with ❤️ for learning and growth**

**ඉගෙනීම සහ වර්ධනය සඳහා ආදරයෙන් නිර්මාණය කරන ලදී**
