# Food Delivery Admin API Documentation

## Authentication
All admin API endpoints require authentication via Laravel Sanctum. Include the Bearer token in the Authorization header.

```
Authorization: Bearer {your_token}
```

## Base URL
```
https://your-domain.com/api/admin
```

## Roles and Permissions
The system uses Spatie Laravel Permission package with the following roles:
- **super-admin**: Full system access
- **admin**: Full admin access except system settings deletion
- **manager**: Restaurant and product management
- **cashier**: Order and payment management
- **delivery-boy**: Delivery operations
- **customer**: Basic user access

---

## 1. Dashboard Analytics Module

### Get Dashboard Analytics
**GET** `/dashboard/analytics`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "total_users": 1250,
        "total_restaurants": 45,
        "total_orders": 3420,
        "total_revenue": 85650.50,
        "pending_orders": 23,
        "active_delivery_boys": 67,
        "today_orders": 89,
        "today_revenue": 2345.75,
        "monthly_growth": 12.5,
        "avg_order_value": 25.50
    }
}
```

### Get Revenue Chart Data
**GET** `/dashboard/revenue-chart?period=monthly&year=2024`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "labels": ["Jan", "Feb", "Mar", "Apr", "May", "Jun"],
        "datasets": [
            {
                "label": "Revenue",
                "data": [12000, 15000, 18000, 22000, 25000, 28000],
                "backgroundColor": "rgba(54, 162, 235, 0.2)",
                "borderColor": "rgba(54, 162, 235, 1)",
                "borderWidth": 1
            }
        ]
    }
}
```

---

## 2. Restaurant Management Module

### List Restaurants
**GET** `/restaurants?page=1&per_page=20&search=pizza&status=active`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 1,
                "name": "Pizza Palace",
                "email": "pizza@palace.com",
                "phone": "+1234567890",
                "address": "123 Main St, City",
                "status": "active",
                "is_approved": true,
                "commission_rate": 10,
                "commission_type": "percentage",
                "total_orders": 234,
                "total_revenue": 12500.50,
                "rating": 4.5,
                "created_at": "2024-01-15T10:30:00Z",
                "owner": {
                    "id": 10,
                    "name": "John Doe",
                    "email": "john@pizzapalace.com"
                }
            }
        ],
        "total": 45,
        "per_page": 20
    }
}
```

### Create Restaurant
**POST** `/restaurants`

**Request Body:**
```json
{
    "name": "Burger King",
    "email": "burger@king.com",
    "phone": "+1234567891",
    "address": "456 Oak Street, City",
    "description": "Best burgers in town",
    "cuisine_type": "American",
    "delivery_time": "30-45 min",
    "delivery_fee": 2.50,
    "minimum_order": 15.00,
    "opening_hours": {
        "monday": "09:00-22:00",
        "tuesday": "09:00-22:00",
        "wednesday": "09:00-22:00",
        "thursday": "09:00-22:00",
        "friday": "09:00-23:00",
        "saturday": "10:00-23:00",
        "sunday": "10:00-21:00"
    },
    "logo": "base64_encoded_image_string",
    "banner": "base64_encoded_image_string"
}
```

**Sample Response:**
```json
{
    "success": true,
    "message": "Restaurant created successfully",
    "data": {
        "id": 46,
        "name": "Burger King",
        "email": "burger@king.com",
        "status": "pending",
        "is_approved": false,
        "created_at": "2024-12-17T15:30:00Z"
    }
}
```

### Update Restaurant Status
**POST** `/restaurants/{id}/approve`

**Sample Response:**
```json
{
    "success": true,
    "message": "Restaurant approved successfully",
    "data": {
        "id": 46,
        "status": "active",
        "is_approved": true,
        "approved_at": "2024-12-17T15:35:00Z"
    }
}
```

---

## 3. Product Management Module

### List Products
**GET** `/products?restaurant_id=1&category_id=2&status=active&search=burger`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 101,
                "name": "Classic Burger",
                "description": "Juicy beef patty with lettuce, tomato, and special sauce",
                "price": 8.99,
                "discounted_price": 7.99,
                "is_available": true,
                "is_veg": false,
                "preparation_time": 15,
                "category": {
                    "id": 2,
                    "name": "Burgers"
                },
                "restaurant": {
                    "id": 1,
                    "name": "Burger Palace"
                },
                "image": "https://your-domain.com/storage/products/burger123.jpg",
                "rating": 4.3,
                "total_orders": 156,
                "created_at": "2024-11-20T08:15:00Z"
            }
        ],
        "total": 23
    }
}
```

### Create Product
**POST** `/products`

**Request Body:**
```json
{
    "name": "Veggie Supreme Pizza",
    "description": "Loaded with fresh vegetables and mozzarella cheese",
    "price": 12.99,
    "discounted_price": 10.99,
    "category_id": 1,
    "restaurant_id": 1,
    "is_veg": true,
    "preparation_time": 20,
    "image": "base64_encoded_image_string",
    "is_available": true
}
```

---

## 4. Category Management Module

### List Categories
**GET** `/categories?status=active&search=food`

**Sample Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "name": "Pizza",
            "slug": "pizza",
            "description": "All types of pizzas",
            "image": "https://your-domain.com/storage/categories/pizza.jpg",
            "is_active": true,
            "sort_order": 1,
            "restaurants_count": 25,
            "products_count": 156,
            "created_at": "2024-01-10T09:00:00Z"
        }
    ]
}
```

### Assign Category to Restaurant
**POST** `/categories/{id}/assign-to-restaurant`

**Request Body:**
```json
{
    "restaurant_id": 5,
    "is_active": true,
    "sort_order": 1
}
```

**Sample Response:**
```json
{
    "success": true,
    "message": "Category assigned to restaurant successfully"
}
```

---

## 5. Delivery Boy Management Module

### List Delivery Boys
**GET** `/delivery-boys?status=active&availability=available`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 15,
                "name": "Mike Johnson",
                "email": "mike@delivery.com",
                "phone": "+1234567894",
                "status": "active",
                "is_approved": true,
                "is_available": true,
                "current_location": {
                    "latitude": 40.7128,
                    "longitude": -74.0060
                },
                "vehicle_type": "motorcycle",
                "vehicle_number": "ABC123",
                "license_number": "DL123456789",
                "commission_rate": 5,
                "total_deliveries": 342,
                "rating": 4.7,
                "wallet_balance": 125.50,
                "created_at": "2024-03-01T10:00:00Z"
            }
        ],
        "total": 67
    }
}
```

### Process Delivery Boy Payout
**POST** `/delivery-boys/{id}/payout`

**Request Body:**
```json
{
    "amount": 100.00,
    "payment_method": "bank_transfer",
    "notes": "Weekly payout for completed deliveries"
}
```

**Sample Response:**
```json
{
    "success": true,
    "message": "Payout processed successfully",
    "data": {
        "payout_id": 78,
        "amount": 100.00,
        "status": "processed",
        "processed_at": "2024-12-17T16:00:00Z"
    }
}
```

---

## 6. Order Management Module

### List Orders
**GET** `/orders?status=pending&restaurant_id=1&date_from=2024-12-01&date_to=2024-12-17`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 1234,
                "order_number": "ORD-2024-1234",
                "user": {
                    "id": 45,
                    "name": "Jane Smith",
                    "phone": "+1234567899"
                },
                "restaurant": {
                    "id": 1,
                    "name": "Pizza Palace"
                },
                "delivery_boy": {
                    "id": 15,
                    "name": "Mike Johnson"
                },
                "status": "preparing",
                "total_amount": 45.99,
                "subtotal": 40.99,
                "tax": 3.60,
                "delivery_fee": 2.50,
                "payment_method": "credit_card",
                "payment_status": "paid",
                "delivery_address": "123 Customer St, City",
                "estimated_delivery_time": "2024-12-17T17:30:00Z",
                "created_at": "2024-12-17T16:45:00Z",
                "items": [
                    {
                        "id": 1,
                        "product_name": "Margherita Pizza",
                        "quantity": 2,
                        "price": 12.99,
                        "total": 25.98
                    }
                ]
            }
        ],
        "total": 89
    }
}
```

### Update Order Status
**PUT** `/orders/{id}/status`

**Request Body:**
```json
{
    "status": "out_for_delivery",
    "notes": "Order is ready and assigned to delivery boy"
}
```

**Sample Response:**
```json
{
    "success": true,
    "message": "Order status updated successfully",
    "data": {
        "id": 1234,
        "status": "out_for_delivery",
        "updated_at": "2024-12-17T17:00:00Z"
    }
}
```

---

## 7. Payment & Commission Management Module

### Get Commission Rules
**GET** `/commissions/rules`

**Sample Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "name": "Restaurant Standard Commission",
            "type": "percentage",
            "value": 10,
            "applicable_to": "restaurant",
            "min_order_amount": 0,
            "max_order_amount": null,
            "is_active": true,
            "created_at": "2024-01-01T00:00:00Z"
        }
    ]
}
```

### Create Commission Rule
**POST** `/commissions/rules`

**Request Body:**
```json
{
    "name": "Delivery Boy Fixed Commission",
    "type": "fixed",
    "value": 5,
    "applicable_to": "delivery_boy",
    "min_order_amount": 15,
    "max_order_amount": 100,
    "is_active": true
}
```

### Get Financial Report
**GET** `/financial-report?date_from=2024-12-01&date_to=2024-12-17`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "total_revenue": 45678.90,
        "total_commissions": 4567.89,
        "total_payouts": 2345.50,
        "net_profit": 38765.51,
        "restaurant_commissions": 3456.78,
        "delivery_boy_commissions": 1111.11,
        "daily_breakdown": [
            {
                "date": "2024-12-17",
                "revenue": 2345.67,
                "commission": 234.57,
                "payout": 123.45
            }
        ]
    }
}
```

---

## 8. User Management Module

### List Users
**GET** `/users?role=customer&status=active&search=john`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 45,
                "name": "John Doe",
                "email": "john@example.com",
                "phone": "+1234567899",
                "role": "customer",
                "status": "active",
                "email_verified": true,
                "total_orders": 23,
                "total_spent": 456.78,
                "wallet_balance": 25.50,
                "last_order_date": "2024-12-15T14:30:00Z",
                "created_at": "2024-01-20T10:00:00Z"
            }
        ],
        "total": 1250
    }
}
```

### Add Wallet Balance
**POST** `/users/{id}/wallet/add`

**Request Body:**
```json
{
    "amount": 50.00,
    "type": "credit",
    "description": "Promotional credit added by admin"
}
```

**Sample Response:**
```json
{
    "success": true,
    "message": "Wallet balance updated successfully",
    "data": {
        "transaction": {
            "id": 789,
            "amount": 50.00,
            "type": "credit",
            "description": "Promotional credit added by admin",
            "created_at": "2024-12-17T18:00:00Z"
        },
        "new_balance": 75.50
    }
}
```

---

## 9. Settings Management Module

### Get Settings by Group
**GET** `/settings/group/general`

**Sample Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "key": "site_name",
            "label": "Site Name",
            "value": "Food Delivery System",
            "type": "text",
            "description": "The name of your food delivery platform"
        },
        {
            "id": 2,
            "key": "site_logo",
            "label": "Site Logo",
            "value": "settings/site_logo.png",
            "type": "image",
            "description": "Your company logo"
        }
    ]
}
```

### Update Setting
**PUT** `/settings/{id}`

**Request Body:**
```json
{
    "value": "My Food Delivery"
}
```

**Sample Response:**
```json
{
    "success": true,
    "message": "Setting updated successfully",
    "data": {
        "id": 1,
        "key": "site_name",
        "value": "My Food Delivery",
        "updated_at": "2024-12-17T18:30:00Z"
    }
}
```

### Get System Information
**GET** `/settings/system-info`

**Sample Response:**
```json
{
    "success": true,
    "data": {
        "php_version": "8.1.25",
        "laravel_version": "10.10.0",
        "app_version": "1.0.0",
        "environment": "production",
        "debug_mode": false,
        "timezone": "UTC",
        "locale": "en",
        "total_users": 1250,
        "total_restaurants": 45,
        "total_delivery_boys": 67,
        "total_orders": 3420,
        "total_revenue": 85650.50,
        "storage_usage": {
            "total": "100 GB",
            "used": "45 GB",
            "free": "55 GB",
            "percentage": 45
        },
        "memory_usage": {
            "limit": "256M",
            "usage": "128 MB",
            "peak": "150 MB",
            "percentage": 50
        },
        "database_size": "125 MB"
    }
}
```

---

## Error Responses

All endpoints return consistent error responses:

### Validation Error (400)
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "name": ["The name field is required."],
        "email": ["The email must be a valid email address."]
    }
}
```

### Unauthorized (401)
```json
{
    "success": false,
    "message": "Unauthorized. Please login to continue."
}
```

### Forbidden (403)
```json
{
    "success": false,
    "message": "You don't have permission to perform this action."
}
```

### Not Found (404)
```json
{
    "success": false,
    "message": "Resource not found."
}
```

### Server Error (500)
```json
{
    "success": false,
    "message": "Something went wrong. Please try again later."
}
```

---

## Rate Limiting
- API requests are rate-limited to 60 requests per minute per user
- Admin endpoints may have different rate limits based on operation complexity

## Pagination
All list endpoints support pagination:
- `page`: Current page number (default: 1)
- `per_page`: Items per page (default: 20, max: 100)

## Filtering
Most list endpoints support filtering via query parameters:
- `search`: Search term for text fields
- `status`: Filter by status
- `date_from`, `date_to`: Date range filtering
- Other specific filters per endpoint

## Sorting
- `sort_by`: Field to sort by
- `sort_order`: `asc` or `desc` (default: asc)